/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.dmn.transformer;

import org.eximeebpms.bpm.dmn.engine.impl.DmnDecisionImpl;
import org.eximeebpms.bpm.dmn.engine.impl.spi.transform.DmnElementTransformContext;
import org.eximeebpms.bpm.dmn.engine.impl.transform.DmnDecisionTransformHandler;
import org.eximeebpms.bpm.engine.impl.HistoryTimeToLiveParser;
import org.eximeebpms.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.eximeebpms.bpm.model.dmn.instance.Decision;

public class DecisionDefinitionHandler
extends DmnDecisionTransformHandler {
    protected boolean skipEnforceTtl = false;

    protected DmnDecisionImpl createDmnElement() {
        return new DecisionDefinitionEntity();
    }

    protected DmnDecisionImpl createFromDecision(DmnElementTransformContext context, Decision decision) {
        DecisionDefinitionEntity decisionDefinition = (DecisionDefinitionEntity)super.createFromDecision(context, decision);
        String category = context.getModelInstance().getDefinitions().getNamespace();
        decisionDefinition.setCategory(category);
        decisionDefinition.setVersionTag(decision.getVersionTag());
        this.validateAndSetHTTL(decision, decisionDefinition, this.isSkipEnforceTtl());
        return decisionDefinition;
    }

    protected void validateAndSetHTTL(Decision decision, DecisionDefinitionEntity decisionDefinition, boolean skipEnforceTtl) {
        Integer historyTimeToLive = HistoryTimeToLiveParser.create().parse(decision, decisionDefinition.getKey(), skipEnforceTtl);
        decisionDefinition.setHistoryTimeToLive(historyTimeToLive);
    }

    public boolean isSkipEnforceTtl() {
        return this.skipEnforceTtl;
    }

    public void setSkipEnforceTtl(boolean skipEnforceTtl) {
        this.skipEnforceTtl = skipEnforceTtl;
    }
}

