/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.el;

import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.delegate.BaseDelegateExecution;
import org.eximeebpms.bpm.engine.delegate.VariableScope;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.delegate.ExpressionGetInvocation;
import org.eximeebpms.bpm.engine.impl.delegate.ExpressionSetInvocation;
import org.eximeebpms.bpm.engine.impl.el.Expression;
import org.eximeebpms.bpm.engine.impl.el.JuelExpressionManager;
import org.eximeebpms.bpm.impl.juel.jakarta.el.ELContext;
import org.eximeebpms.bpm.impl.juel.jakarta.el.ELException;
import org.eximeebpms.bpm.impl.juel.jakarta.el.MethodNotFoundException;
import org.eximeebpms.bpm.impl.juel.jakarta.el.PropertyNotFoundException;
import org.eximeebpms.bpm.impl.juel.jakarta.el.ValueExpression;

public class JuelExpression
implements Expression {
    protected String expressionText;
    protected ValueExpression valueExpression;
    protected JuelExpressionManager expressionManager;

    public JuelExpression(ValueExpression valueExpression, JuelExpressionManager expressionManager, String expressionText) {
        this.valueExpression = valueExpression;
        this.expressionManager = expressionManager;
        this.expressionText = expressionText;
    }

    @Override
    public Object getValue(VariableScope variableScope) {
        return this.getValue(variableScope, null);
    }

    @Override
    public Object getValue(VariableScope variableScope, BaseDelegateExecution contextExecution) {
        ELContext elContext = this.expressionManager.getElContext(variableScope);
        try {
            ExpressionGetInvocation invocation = new ExpressionGetInvocation(this.valueExpression, elContext, contextExecution);
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
            return invocation.getInvocationResult();
        }
        catch (PropertyNotFoundException pnfe) {
            throw new ProcessEngineException("Unknown property used in expression: " + this.expressionText + ". Cause: " + pnfe.getMessage(), pnfe);
        }
        catch (MethodNotFoundException mnfe) {
            throw new ProcessEngineException("Unknown method used in expression: " + this.expressionText + ". Cause: " + mnfe.getMessage(), mnfe);
        }
        catch (ELException ele) {
            Throwable cause = ele.getCause();
            if (cause != null) {
                throw new ProcessEngineException(cause);
            }
            throw new ProcessEngineException("Error while evaluating expression: " + this.expressionText + ". Cause: " + ele.getMessage(), ele);
        }
        catch (Exception e) {
            throw new ProcessEngineException("Error while evaluating expression: " + this.expressionText + ". Cause: " + e.getMessage(), e);
        }
    }

    @Override
    public void setValue(Object value, VariableScope variableScope) {
        this.setValue(value, variableScope, null);
    }

    @Override
    public void setValue(Object value, VariableScope variableScope, BaseDelegateExecution contextExecution) {
        ELContext elContext = this.expressionManager.getElContext(variableScope);
        try {
            ExpressionSetInvocation invocation = new ExpressionSetInvocation(this.valueExpression, elContext, value, contextExecution);
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
        }
        catch (Exception e) {
            throw new ProcessEngineException("Error while evaluating expression: " + this.expressionText + ". Cause: " + e.getMessage(), e);
        }
    }

    public String toString() {
        if (this.valueExpression != null) {
            return this.valueExpression.getExpressionString();
        }
        return super.toString();
    }

    @Override
    public boolean isLiteralText() {
        return this.valueExpression.isLiteralText();
    }

    @Override
    public String getExpressionText() {
        return this.expressionText;
    }
}

