/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.event;

import java.util.List;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.bpmn.helper.CompensationUtil;
import org.eximeebpms.bpm.engine.impl.event.EventHandler;
import org.eximeebpms.bpm.engine.impl.event.EventType;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.eximeebpms.bpm.engine.impl.pvm.process.ActivityImpl;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class CompensationEventHandler
implements EventHandler {
    @Override
    public String getEventHandlerType() {
        return EventType.COMPENSATE.name();
    }

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, Object localPayload, Object payloadToTriggeredScope, String businessKey, CommandContext commandContext) {
        eventSubscription.delete();
        String configuration = eventSubscription.getConfiguration();
        EnsureUtil.ensureNotNull("Compensating execution not set for compensate event subscription with id " + eventSubscription.getId(), "configuration", (Object)configuration);
        ExecutionEntity compensatingExecution = commandContext.getExecutionManager().findExecutionById(configuration);
        ActivityImpl compensationHandler = eventSubscription.getActivity();
        compensatingExecution.setActive(true);
        if (compensatingExecution.getActivity().getActivityBehavior() instanceof CompositeActivityBehavior) {
            compensatingExecution.getParent().setActivityInstanceId(compensatingExecution.getActivityInstanceId());
        }
        if (compensationHandler.isScope() && !compensationHandler.isCompensationHandler()) {
            List<EventSubscriptionEntity> eventsForThisScope = compensatingExecution.getCompensateEventSubscriptions();
            CompensationUtil.throwCompensationEvent(eventsForThisScope, compensatingExecution, false);
        } else {
            try {
                if (compensationHandler.isSubProcessScope() && compensationHandler.isTriggeredByEvent()) {
                    compensatingExecution.executeActivity(compensationHandler);
                } else {
                    compensatingExecution.setActivity(compensationHandler);
                    compensatingExecution.performOperation(PvmAtomicOperation.ACTIVITY_START);
                }
            }
            catch (Exception e) {
                throw new ProcessEngineException("Error while handling compensation event " + eventSubscription, e);
            }
        }
    }
}

