/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.form.handler;

import org.eximeebpms.bpm.engine.delegate.VariableScope;
import org.eximeebpms.bpm.engine.form.FormFieldValidationConstraint;
import org.eximeebpms.bpm.engine.impl.form.FormFieldValidationConstraintImpl;
import org.eximeebpms.bpm.engine.impl.form.handler.DefaultFormFieldValidatorContext;
import org.eximeebpms.bpm.engine.impl.form.handler.FormFieldHandler;
import org.eximeebpms.bpm.engine.impl.form.validator.FormFieldValidationException;
import org.eximeebpms.bpm.engine.impl.form.validator.FormFieldValidator;
import org.eximeebpms.bpm.engine.impl.form.validator.FormFieldValidatorException;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.variable.VariableMap;

public class FormFieldValidationConstraintHandler {
    protected String name;
    protected String config;
    protected FormFieldValidator validator;

    public FormFieldValidationConstraint createValidationConstraint(ExecutionEntity execution) {
        return new FormFieldValidationConstraintImpl(this.name, this.config);
    }

    public void validate(Object submittedValue, VariableMap submittedValues, FormFieldHandler formFieldHandler, VariableScope variableScope) {
        try {
            DefaultFormFieldValidatorContext context = new DefaultFormFieldValidatorContext(variableScope, this.config, submittedValues, formFieldHandler);
            if (!this.validator.validate(submittedValue, context)) {
                throw new FormFieldValidatorException(formFieldHandler.getId(), this.name, this.config, submittedValue, "Invalid value submitted for form field '" + formFieldHandler.getId() + "': validation of " + this + " failed.");
            }
        }
        catch (FormFieldValidationException e) {
            throw new FormFieldValidatorException(formFieldHandler.getId(), this.name, this.config, submittedValue, "Invalid value submitted for form field '" + formFieldHandler.getId() + "': validation of " + this + " failed.", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getConfig() {
        return this.config;
    }

    public void setValidator(FormFieldValidator validator) {
        this.validator = validator;
    }

    public FormFieldValidator getValidator() {
        return this.validator;
    }

    public String toString() {
        return this.name + (String)(this.config != null ? "(" + this.config + ")" : "");
    }
}

