/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.history;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.batch.history.HistoricBatchQuery;
import org.eximeebpms.bpm.engine.history.SetRemovalTimeSelectModeForHistoricBatchesBuilder;
import org.eximeebpms.bpm.engine.history.SetRemovalTimeToHistoricBatchesBuilder;
import org.eximeebpms.bpm.engine.impl.cmd.batch.removaltime.SetRemovalTimeToHistoricBatchesCmd;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandExecutor;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class SetRemovalTimeToHistoricBatchesBuilderImpl
implements SetRemovalTimeSelectModeForHistoricBatchesBuilder {
    protected HistoricBatchQuery query;
    protected List<String> ids;
    protected Mode mode = null;
    protected Date removalTime;
    protected CommandExecutor commandExecutor;

    public SetRemovalTimeToHistoricBatchesBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public SetRemovalTimeToHistoricBatchesBuilder byQuery(HistoricBatchQuery query) {
        this.query = query;
        return this;
    }

    @Override
    public SetRemovalTimeToHistoricBatchesBuilder byIds(String ... ids) {
        this.ids = ids != null ? Arrays.asList(ids) : null;
        return this;
    }

    @Override
    public SetRemovalTimeToHistoricBatchesBuilder absoluteRemovalTime(Date removalTime) {
        EnsureUtil.ensureNull(BadUserRequestException.class, "The removal time modes are mutually exclusive", "mode", (Object)this.mode);
        this.mode = Mode.ABSOLUTE_REMOVAL_TIME;
        this.removalTime = removalTime;
        return this;
    }

    @Override
    public SetRemovalTimeToHistoricBatchesBuilder calculatedRemovalTime() {
        EnsureUtil.ensureNull(BadUserRequestException.class, "The removal time modes are mutually exclusive", "mode", (Object)this.mode);
        this.mode = Mode.CALCULATED_REMOVAL_TIME;
        return this;
    }

    @Override
    public SetRemovalTimeToHistoricBatchesBuilder clearedRemovalTime() {
        EnsureUtil.ensureNull(BadUserRequestException.class, "The removal time modes are mutually exclusive", "mode", (Object)this.mode);
        this.mode = Mode.CLEARED_REMOVAL_TIME;
        return this;
    }

    @Override
    public Batch executeAsync() {
        return this.commandExecutor.execute(new SetRemovalTimeToHistoricBatchesCmd(this));
    }

    public HistoricBatchQuery getQuery() {
        return this.query;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public Date getRemovalTime() {
        return this.removalTime;
    }

    public Mode getMode() {
        return this.mode;
    }

    public static enum Mode {
        CALCULATED_REMOVAL_TIME,
        ABSOLUTE_REMOVAL_TIME,
        CLEARED_REMOVAL_TIME;

    }
}

