/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.history.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.history.CleanableHistoricDecisionInstanceReportResult;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInputInstance;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstance;
import org.eximeebpms.bpm.engine.history.HistoricDecisionOutputInstance;
import org.eximeebpms.bpm.engine.impl.CleanableHistoricDecisionInstanceReportImpl;
import org.eximeebpms.bpm.engine.impl.HistoricDecisionInstanceQueryImpl;
import org.eximeebpms.bpm.engine.impl.Page;
import org.eximeebpms.bpm.engine.impl.db.DbEntity;
import org.eximeebpms.bpm.engine.impl.db.ListQueryParameterObject;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.operation.DbBulkOperation;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricDecisionEvaluationEvent;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricDecisionInputInstanceEntity;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricDecisionInstanceEntity;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricDecisionOutputInstanceEntity;
import org.eximeebpms.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.impl.util.ImmutablePair;
import org.eximeebpms.bpm.engine.impl.variable.serializer.AbstractTypedValueSerializer;

public class HistoricDecisionInstanceManager
extends AbstractHistoricManager {
    public void deleteHistoricDecisionInstancesByDecisionDefinitionId(String decisionDefinitionId) {
        if (this.isHistoryEnabled()) {
            List<HistoricDecisionInstanceEntity> decisionInstances = this.findHistoricDecisionInstancesByDecisionDefinitionId(decisionDefinitionId);
            ArrayList<String> decisionInstanceIds = new ArrayList<String>();
            for (HistoricDecisionInstanceEntity decisionInstance : decisionInstances) {
                decisionInstanceIds.add(decisionInstance.getId());
                decisionInstance.delete();
            }
            if (!decisionInstanceIds.isEmpty()) {
                this.deleteHistoricDecisionInstanceByIds(decisionInstanceIds);
            }
        }
    }

    protected List<HistoricDecisionInstanceEntity> findHistoricDecisionInstancesByDecisionDefinitionId(String decisionDefinitionId) {
        return this.getDbEntityManager().selectList("selectHistoricDecisionInstancesByDecisionDefinitionId", this.configureParameterizedQuery(decisionDefinitionId));
    }

    public void deleteHistoricDecisionInstanceByIds(List<String> decisionInstanceIds) {
        this.getDbEntityManager().deletePreserveOrder(ByteArrayEntity.class, "deleteHistoricDecisionInputInstanceByteArraysByDecisionInstanceIds", decisionInstanceIds);
        this.getDbEntityManager().deletePreserveOrder(ByteArrayEntity.class, "deleteHistoricDecisionOutputInstanceByteArraysByDecisionInstanceIds", decisionInstanceIds);
        this.getDbEntityManager().deletePreserveOrder(HistoricDecisionInputInstanceEntity.class, "deleteHistoricDecisionInputInstanceByDecisionInstanceIds", decisionInstanceIds);
        this.getDbEntityManager().deletePreserveOrder(HistoricDecisionOutputInstanceEntity.class, "deleteHistoricDecisionOutputInstanceByDecisionInstanceIds", decisionInstanceIds);
        this.getDbEntityManager().deletePreserveOrder(HistoricDecisionInstanceEntity.class, "deleteHistoricDecisionInstanceByIds", decisionInstanceIds);
    }

    public void insertHistoricDecisionInstances(HistoricDecisionEvaluationEvent event) {
        if (this.isHistoryEnabled()) {
            HistoricDecisionInstanceEntity rootHistoricDecisionInstance = event.getRootHistoricDecisionInstance();
            this.insertHistoricDecisionInstance(rootHistoricDecisionInstance);
            for (HistoricDecisionInstanceEntity requiredHistoricDecisionInstances : event.getRequiredHistoricDecisionInstances()) {
                requiredHistoricDecisionInstances.setRootDecisionInstanceId(rootHistoricDecisionInstance.getId());
                this.insertHistoricDecisionInstance(requiredHistoricDecisionInstances);
            }
        }
    }

    protected void insertHistoricDecisionInstance(HistoricDecisionInstanceEntity historicDecisionInstance) {
        this.getDbEntityManager().insert(historicDecisionInstance);
        this.insertHistoricDecisionInputInstances(historicDecisionInstance.getInputs(), historicDecisionInstance.getId());
        this.insertHistoricDecisionOutputInstances(historicDecisionInstance.getOutputs(), historicDecisionInstance.getId());
    }

    protected void insertHistoricDecisionInputInstances(List<HistoricDecisionInputInstance> inputs, String decisionInstanceId) {
        for (HistoricDecisionInputInstance input : inputs) {
            HistoricDecisionInputInstanceEntity inputEntity = (HistoricDecisionInputInstanceEntity)input;
            inputEntity.setDecisionInstanceId(decisionInstanceId);
            this.getDbEntityManager().insert(inputEntity);
        }
    }

    protected void insertHistoricDecisionOutputInstances(List<HistoricDecisionOutputInstance> outputs, String decisionInstanceId) {
        for (HistoricDecisionOutputInstance output : outputs) {
            HistoricDecisionOutputInstanceEntity outputEntity = (HistoricDecisionOutputInstanceEntity)output;
            outputEntity.setDecisionInstanceId(decisionInstanceId);
            this.getDbEntityManager().insert(outputEntity);
        }
    }

    public List<HistoricDecisionInstance> findHistoricDecisionInstancesByQueryCriteria(HistoricDecisionInstanceQueryImpl query, Page page) {
        if (this.isHistoryEnabled()) {
            this.configureQuery(query);
            List decisionInstances = this.getDbEntityManager().selectList("selectHistoricDecisionInstancesByQueryCriteria", query, page);
            this.enrichHistoricDecisionsWithInputsAndOutputs(query, decisionInstances);
            return decisionInstances;
        }
        return Collections.emptyList();
    }

    public List<ImmutablePair<String, String>> findHistoricDecisionInstanceDeploymentIdMappingsByQueryCriteria(HistoricDecisionInstanceQueryImpl query) {
        if (this.isHistoryEnabled()) {
            this.configureQuery(query);
            return this.getDbEntityManager().selectList("selectHistoricDecisionInstanceDeploymentIdMappingsByQueryCriteria", query);
        }
        return Collections.emptyList();
    }

    public void enrichHistoricDecisionsWithInputsAndOutputs(HistoricDecisionInstanceQueryImpl query, List<HistoricDecisionInstance> decisionInstances) {
        HashMap<String, HistoricDecisionInstanceEntity> decisionInstancesById = new HashMap<String, HistoricDecisionInstanceEntity>();
        for (HistoricDecisionInstance decisionInstance : decisionInstances) {
            decisionInstancesById.put(decisionInstance.getId(), (HistoricDecisionInstanceEntity)decisionInstance);
        }
        if (!decisionInstances.isEmpty() && query.isIncludeInput()) {
            this.appendHistoricDecisionInputInstances(decisionInstancesById, query);
        }
        if (!decisionInstances.isEmpty() && query.isIncludeOutputs()) {
            this.appendHistoricDecisionOutputInstances(decisionInstancesById, query);
        }
    }

    public List<String> findHistoricDecisionInstanceIdsForCleanup(Integer batchSize, int minuteFrom, int minuteTo) {
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("currentTimestamp", ClockUtil.getCurrentTime());
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        ListQueryParameterObject parameterObject = new ListQueryParameterObject(parameters, 0, batchSize);
        return this.getDbEntityManager().selectList("selectHistoricDecisionInstanceIdsForCleanup", parameterObject);
    }

    protected void appendHistoricDecisionInputInstances(Map<String, HistoricDecisionInstanceEntity> decisionInstancesById, HistoricDecisionInstanceQueryImpl query) {
        List<HistoricDecisionInputInstanceEntity> decisionInputInstances = this.findHistoricDecisionInputInstancesByDecisionInstanceIds(decisionInstancesById.keySet());
        this.initializeInputInstances(decisionInstancesById.values());
        for (HistoricDecisionInputInstanceEntity decisionInputInstance : decisionInputInstances) {
            HistoricDecisionInstanceEntity historicDecisionInstance = decisionInstancesById.get(decisionInputInstance.getDecisionInstanceId());
            historicDecisionInstance.addInput(decisionInputInstance);
            if (this.isBinaryValue(decisionInputInstance) && !query.isByteArrayFetchingEnabled()) continue;
            this.fetchVariableValue(decisionInputInstance, query.isCustomObjectDeserializationEnabled());
        }
    }

    protected void initializeInputInstances(Collection<HistoricDecisionInstanceEntity> decisionInstances) {
        for (HistoricDecisionInstanceEntity decisionInstance : decisionInstances) {
            decisionInstance.setInputs(new ArrayList<HistoricDecisionInputInstance>());
        }
    }

    protected List<HistoricDecisionInputInstanceEntity> findHistoricDecisionInputInstancesByDecisionInstanceIds(Set<String> historicDecisionInstanceKeys) {
        return this.getDbEntityManager().selectList("selectHistoricDecisionInputInstancesByDecisionInstanceIds", historicDecisionInstanceKeys);
    }

    protected boolean isBinaryValue(HistoricDecisionInputInstance decisionInputInstance) {
        return AbstractTypedValueSerializer.BINARY_VALUE_TYPES.contains(decisionInputInstance.getTypeName());
    }

    protected void fetchVariableValue(HistoricDecisionInputInstanceEntity decisionInputInstance, boolean isCustomObjectDeserializationEnabled) {
        try {
            decisionInputInstance.getTypedValue(isCustomObjectDeserializationEnabled);
        }
        catch (Exception t) {
            LOG.failedTofetchVariableValue(t);
        }
    }

    protected void appendHistoricDecisionOutputInstances(Map<String, HistoricDecisionInstanceEntity> decisionInstancesById, HistoricDecisionInstanceQueryImpl query) {
        List<HistoricDecisionOutputInstanceEntity> decisionOutputInstances = this.findHistoricDecisionOutputInstancesByDecisionInstanceIds(decisionInstancesById.keySet());
        this.initializeOutputInstances(decisionInstancesById.values());
        for (HistoricDecisionOutputInstanceEntity decisionOutputInstance : decisionOutputInstances) {
            HistoricDecisionInstanceEntity historicDecisionInstance = decisionInstancesById.get(decisionOutputInstance.getDecisionInstanceId());
            historicDecisionInstance.addOutput(decisionOutputInstance);
            if (this.isBinaryValue(decisionOutputInstance) && !query.isByteArrayFetchingEnabled()) continue;
            this.fetchVariableValue(decisionOutputInstance, query.isCustomObjectDeserializationEnabled());
        }
    }

    protected void initializeOutputInstances(Collection<HistoricDecisionInstanceEntity> decisionInstances) {
        for (HistoricDecisionInstanceEntity decisionInstance : decisionInstances) {
            decisionInstance.setOutputs(new ArrayList<HistoricDecisionOutputInstance>());
        }
    }

    protected List<HistoricDecisionOutputInstanceEntity> findHistoricDecisionOutputInstancesByDecisionInstanceIds(Set<String> decisionInstanceKeys) {
        return this.getDbEntityManager().selectList("selectHistoricDecisionOutputInstancesByDecisionInstanceIds", decisionInstanceKeys);
    }

    protected boolean isBinaryValue(HistoricDecisionOutputInstance decisionOutputInstance) {
        return AbstractTypedValueSerializer.BINARY_VALUE_TYPES.contains(decisionOutputInstance.getTypeName());
    }

    protected void fetchVariableValue(HistoricDecisionOutputInstanceEntity decisionOutputInstance, boolean isCustomObjectDeserializationEnabled) {
        try {
            decisionOutputInstance.getTypedValue(isCustomObjectDeserializationEnabled);
        }
        catch (Exception t) {
            LOG.failedTofetchVariableValue(t);
        }
    }

    public HistoricDecisionInstanceEntity findHistoricDecisionInstance(String historicDecisionInstanceId) {
        if (this.isHistoryEnabled()) {
            return (HistoricDecisionInstanceEntity)this.getDbEntityManager().selectOne("selectHistoricDecisionInstanceByDecisionInstanceId", this.configureParameterizedQuery(historicDecisionInstanceId));
        }
        return null;
    }

    public long findHistoricDecisionInstanceCountByQueryCriteria(HistoricDecisionInstanceQueryImpl query) {
        if (this.isHistoryEnabled()) {
            this.configureQuery(query);
            return (Long)this.getDbEntityManager().selectOne("selectHistoricDecisionInstanceCountByQueryCriteria", query);
        }
        return 0L;
    }

    public List<HistoricDecisionInstance> findHistoricDecisionInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbEntityManager().selectListWithRawParameter("selectHistoricDecisionInstancesByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findHistoricDecisionInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbEntityManager().selectOne("selectHistoricDecisionInstanceCountByNativeQuery", parameterMap);
    }

    protected void configureQuery(HistoricDecisionInstanceQueryImpl query) {
        this.getAuthorizationManager().configureHistoricDecisionInstanceQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    protected ListQueryParameterObject configureParameterizedQuery(Object parameter) {
        return this.getTenantManager().configureQuery(parameter);
    }

    public List<CleanableHistoricDecisionInstanceReportResult> findCleanableHistoricDecisionInstancesReportByCriteria(CleanableHistoricDecisionInstanceReportImpl query, Page page) {
        query.setCurrentTimestamp(ClockUtil.getCurrentTime());
        this.getAuthorizationManager().configureQueryHistoricFinishedInstanceReport(query, Resources.DECISION_DEFINITION);
        this.getTenantManager().configureQuery(query);
        return this.getDbEntityManager().selectList("selectFinishedDecisionInstancesReportEntities", query, page);
    }

    public long findCleanableHistoricDecisionInstancesReportCountByCriteria(CleanableHistoricDecisionInstanceReportImpl query) {
        query.setCurrentTimestamp(ClockUtil.getCurrentTime());
        this.getAuthorizationManager().configureQueryHistoricFinishedInstanceReport(query, Resources.DECISION_DEFINITION);
        this.getTenantManager().configureQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectFinishedDecisionInstancesReportEntitiesCount", query);
    }

    public void addRemovalTimeToDecisionsByRootProcessInstanceId(String rootProcessInstanceId, Date removalTime) {
        this.addRemovalTimeToDecisionsByRootProcessInstanceId(rootProcessInstanceId, removalTime, null, Collections.emptySet());
    }

    public Map<Class<? extends DbEntity>, DbOperation> addRemovalTimeToDecisionsByRootProcessInstanceId(String rootProcessInstanceId, Date removalTime, Integer batchSize, Set<String> entities) {
        HashMap<Class<? extends DbEntity>, DbOperation> updateOperations = new HashMap<Class<? extends DbEntity>, DbOperation>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rootProcessInstanceId", rootProcessInstanceId);
        parameters.put("removalTime", removalTime);
        parameters.put("maxResults", batchSize);
        if (HistoricDecisionInstanceManager.isPerformUpdate(entities, HistoricDecisionInstanceEntity.class)) {
            HistoricDecisionInstanceManager.addOperation(this.getDbEntityManager().updatePreserveOrder(HistoricDecisionInstanceEntity.class, "updateHistoricDecisionInstancesByRootProcessInstanceId", parameters), updateOperations);
        }
        if (HistoricDecisionInstanceManager.isPerformUpdate(entities, HistoricDecisionInputInstanceEntity.class)) {
            HistoricDecisionInstanceManager.addOperation(this.getDbEntityManager().updatePreserveOrder(HistoricDecisionInputInstanceEntity.class, "updateHistoricDecisionInputInstancesByRootProcessInstanceId", parameters), updateOperations);
        }
        if (HistoricDecisionInstanceManager.isPerformUpdate(entities, HistoricDecisionOutputInstanceEntity.class)) {
            HistoricDecisionInstanceManager.addOperation(this.getDbEntityManager().updatePreserveOrder(HistoricDecisionOutputInstanceEntity.class, "updateHistoricDecisionOutputInstancesByRootProcessInstanceId", parameters), updateOperations);
        }
        return updateOperations;
    }

    public void addRemovalTimeToDecisionsByProcessInstanceId(String processInstanceId, Date removalTime) {
        this.addRemovalTimeToDecisionsByProcessInstanceId(processInstanceId, removalTime, null, Collections.emptySet());
    }

    public Map<Class<? extends DbEntity>, DbOperation> addRemovalTimeToDecisionsByProcessInstanceId(String processInstanceId, Date removalTime, Integer batchSize, Set<String> entities) {
        HashMap<Class<? extends DbEntity>, DbOperation> updateOperations = new HashMap<Class<? extends DbEntity>, DbOperation>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("removalTime", removalTime);
        parameters.put("maxResults", batchSize);
        if (HistoricDecisionInstanceManager.isPerformUpdate(entities, HistoricDecisionInstanceEntity.class)) {
            HistoricDecisionInstanceManager.addOperation(this.getDbEntityManager().updatePreserveOrder(HistoricDecisionInstanceEntity.class, "updateHistoricDecisionInstancesByProcessInstanceId", parameters), updateOperations);
        }
        if (HistoricDecisionInstanceManager.isPerformUpdate(entities, HistoricDecisionInputInstanceEntity.class)) {
            HistoricDecisionInstanceManager.addOperation(this.getDbEntityManager().updatePreserveOrder(HistoricDecisionInputInstanceEntity.class, "updateHistoricDecisionInputInstancesByProcessInstanceId", parameters), updateOperations);
        }
        if (HistoricDecisionInstanceManager.isPerformUpdate(entities, HistoricDecisionOutputInstanceEntity.class)) {
            HistoricDecisionInstanceManager.addOperation(this.getDbEntityManager().updatePreserveOrder(HistoricDecisionOutputInstanceEntity.class, "updateHistoricDecisionOutputInstancesByProcessInstanceId", parameters), updateOperations);
        }
        return updateOperations;
    }

    public void addRemovalTimeToDecisionsByRootDecisionInstanceId(String rootInstanceId, Date removalTime) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rootDecisionInstanceId", rootInstanceId);
        parameters.put("removalTime", removalTime);
        this.getDbEntityManager().updatePreserveOrder(HistoricDecisionInstanceEntity.class, "updateHistoricDecisionInstancesByRootDecisionInstanceId", parameters);
        this.getDbEntityManager().updatePreserveOrder(HistoricDecisionInputInstanceEntity.class, "updateHistoricDecisionInputInstancesByRootDecisionInstanceId", parameters);
        this.getDbEntityManager().updatePreserveOrder(HistoricDecisionOutputInstanceEntity.class, "updateHistoricDecisionOutputInstancesByRootDecisionInstanceId", parameters);
        this.getDbEntityManager().updatePreserveOrder(ByteArrayEntity.class, "updateDecisionInputByteArraysByRootDecisionInstanceId", parameters);
        this.getDbEntityManager().updatePreserveOrder(ByteArrayEntity.class, "updateDecisionOutputByteArraysByRootDecisionInstanceId", parameters);
    }

    public void addRemovalTimeToDecisionsByDecisionInstanceId(String instanceId, Date removalTime) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("decisionInstanceId", instanceId);
        parameters.put("removalTime", removalTime);
        this.getDbEntityManager().updatePreserveOrder(HistoricDecisionInstanceEntity.class, "updateHistoricDecisionInstancesByDecisionInstanceId", parameters);
        this.getDbEntityManager().updatePreserveOrder(HistoricDecisionInputInstanceEntity.class, "updateHistoricDecisionInputInstancesByDecisionInstanceId", parameters);
        this.getDbEntityManager().updatePreserveOrder(HistoricDecisionOutputInstanceEntity.class, "updateHistoricDecisionOutputInstancesByDecisionInstanceId", parameters);
        this.getDbEntityManager().updatePreserveOrder(ByteArrayEntity.class, "updateDecisionInputByteArraysByDecisionInstanceId", parameters);
        this.getDbEntityManager().updatePreserveOrder(ByteArrayEntity.class, "updateDecisionOutputByteArraysByDecisionInstanceId", parameters);
    }

    public Map<Class<? extends DbEntity>, DbOperation> deleteHistoricDecisionsByRemovalTime(Date removalTime, int minuteFrom, int minuteTo, int batchSize) {
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("removalTime", removalTime);
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        parameters.put("batchSize", Integer.valueOf(batchSize));
        HashMap<Class<? extends DbEntity>, DbOperation> deleteOperations = new HashMap<Class<? extends DbEntity>, DbOperation>();
        DbBulkOperation deleteDecisionInputInstances = this.getDbEntityManager().deletePreserveOrder(HistoricDecisionInputInstanceEntity.class, "deleteHistoricDecisionInputInstancesByRemovalTime", new ListQueryParameterObject(parameters, 0, batchSize));
        deleteOperations.put(HistoricDecisionInputInstanceEntity.class, deleteDecisionInputInstances);
        DbBulkOperation deleteDecisionOutputInstances = this.getDbEntityManager().deletePreserveOrder(HistoricDecisionOutputInstanceEntity.class, "deleteHistoricDecisionOutputInstancesByRemovalTime", new ListQueryParameterObject(parameters, 0, batchSize));
        deleteOperations.put(HistoricDecisionOutputInstanceEntity.class, deleteDecisionOutputInstances);
        DbBulkOperation deleteDecisionInstances = this.getDbEntityManager().deletePreserveOrder(HistoricDecisionInstanceEntity.class, "deleteHistoricDecisionInstancesByRemovalTime", new ListQueryParameterObject(parameters, 0, batchSize));
        deleteOperations.put(HistoricDecisionInstanceEntity.class, deleteDecisionInstances);
        return deleteOperations;
    }
}

