/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.history.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eximeebpms.bpm.engine.impl.history.event.HistoryEvent;
import org.eximeebpms.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class CompositeHistoryEventHandler
implements HistoryEventHandler {
    protected final List<HistoryEventHandler> historyEventHandlers = new ArrayList<HistoryEventHandler>();

    public CompositeHistoryEventHandler() {
    }

    public CompositeHistoryEventHandler(HistoryEventHandler ... historyEventHandlers) {
        this.initializeHistoryEventHandlers(Arrays.asList(historyEventHandlers));
    }

    public CompositeHistoryEventHandler(List<HistoryEventHandler> historyEventHandlers) {
        this.initializeHistoryEventHandlers(historyEventHandlers);
    }

    private void initializeHistoryEventHandlers(List<HistoryEventHandler> historyEventHandlers) {
        EnsureUtil.ensureNotNull("History event handler", historyEventHandlers);
        for (HistoryEventHandler historyEventHandler : historyEventHandlers) {
            EnsureUtil.ensureNotNull("History event handler", (Object)historyEventHandler);
            this.historyEventHandlers.add(historyEventHandler);
        }
    }

    public void add(HistoryEventHandler historyEventHandler) {
        EnsureUtil.ensureNotNull("History event handler", (Object)historyEventHandler);
        this.historyEventHandlers.add(historyEventHandler);
    }

    @Override
    public void handleEvent(HistoryEvent historyEvent) {
        for (HistoryEventHandler historyEventHandler : this.historyEventHandlers) {
            historyEventHandler.handleEvent(historyEvent);
        }
    }

    @Override
    public void handleEvents(List<HistoryEvent> historyEvents) {
        for (HistoryEvent historyEvent : historyEvents) {
            this.handleEvent(historyEvent);
        }
    }
}

