/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.identity;

import java.util.HashMap;
import java.util.Map;
import org.eximeebpms.bpm.engine.identity.PasswordPolicyRule;

public class PasswordPolicyLowerCaseRuleImpl
implements PasswordPolicyRule {
    public static final String PLACEHOLDER = "PASSWORD_POLICY_LOWERCASE";
    protected int minLowerCase;

    public PasswordPolicyLowerCaseRuleImpl(int minLowerCase) {
        this.minLowerCase = minLowerCase;
    }

    @Override
    public String getPlaceholder() {
        return PLACEHOLDER;
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("minLowerCase", "" + this.minLowerCase);
        return parameter;
    }

    @Override
    public boolean execute(String password) {
        int lowerCaseCount = 0;
        char[] cArray = password.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (Character.isLowerCase(c.charValue())) {
                ++lowerCaseCount;
            }
            if (lowerCaseCount < this.minLowerCase) continue;
            return true;
        }
        return false;
    }
}

