/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.incident;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.incident.IncidentContext;
import org.eximeebpms.bpm.engine.impl.incident.IncidentHandler;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;
import org.eximeebpms.bpm.engine.runtime.Incident;

public class CompositeIncidentHandler
implements IncidentHandler {
    protected IncidentHandler mainIncidentHandler;
    protected final List<IncidentHandler> incidentHandlers = new ArrayList<IncidentHandler>();

    public CompositeIncidentHandler(IncidentHandler mainIncidentHandler, List<IncidentHandler> incidentHandlers) {
        this.initializeIncidentsHandlers(mainIncidentHandler, incidentHandlers);
    }

    public CompositeIncidentHandler(IncidentHandler mainIncidentHandler, IncidentHandler ... incidentHandlers) {
        EnsureUtil.ensureNotNull("Incident handlers", incidentHandlers);
        this.initializeIncidentsHandlers(mainIncidentHandler, Arrays.asList(incidentHandlers));
    }

    protected void initializeIncidentsHandlers(IncidentHandler mainIncidentHandler, List<IncidentHandler> incidentHandlers) {
        EnsureUtil.ensureNotNull("Incident handler", (Object)mainIncidentHandler);
        this.mainIncidentHandler = mainIncidentHandler;
        EnsureUtil.ensureNotNull("Incident handlers", incidentHandlers);
        for (IncidentHandler incidentHandler : incidentHandlers) {
            this.add(incidentHandler);
        }
    }

    public void add(IncidentHandler incidentHandler) {
        EnsureUtil.ensureNotNull("Incident handler", (Object)incidentHandler);
        String incidentHandlerType = this.getIncidentHandlerType();
        if (!incidentHandlerType.equals(incidentHandler.getIncidentHandlerType())) {
            throw new ProcessEngineException("Incorrect incident type handler in composite handler with type: " + incidentHandlerType);
        }
        this.incidentHandlers.add(incidentHandler);
    }

    @Override
    public String getIncidentHandlerType() {
        return this.mainIncidentHandler.getIncidentHandlerType();
    }

    @Override
    public Incident handleIncident(IncidentContext context, String message) {
        Incident incident = this.mainIncidentHandler.handleIncident(context, message);
        for (IncidentHandler incidentHandler : this.incidentHandlers) {
            incidentHandler.handleIncident(context, message);
        }
        return incident;
    }

    @Override
    public void resolveIncident(IncidentContext context) {
        this.mainIncidentHandler.resolveIncident(context);
        for (IncidentHandler incidentHandler : this.incidentHandlers) {
            incidentHandler.resolveIncident(context);
        }
    }

    @Override
    public void deleteIncident(IncidentContext context) {
        this.mainIncidentHandler.deleteIncident(context);
        for (IncidentHandler incidentHandler : this.incidentHandlers) {
            incidentHandler.deleteIncident(context);
        }
    }
}

