/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.incident;

import java.util.List;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.incident.IncidentContext;
import org.eximeebpms.bpm.engine.impl.incident.IncidentHandler;
import org.eximeebpms.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.eximeebpms.bpm.engine.runtime.Incident;

public class DefaultIncidentHandler
implements IncidentHandler {
    protected String type;

    public DefaultIncidentHandler(String type) {
        this.type = type;
    }

    @Override
    public String getIncidentHandlerType() {
        return this.type;
    }

    @Override
    public Incident handleIncident(IncidentContext context, String message) {
        return this.createIncident(context, message);
    }

    public Incident createIncident(IncidentContext context, String message) {
        IncidentEntity newIncident = IncidentEntity.createAndInsertIncident(this.type, context, message);
        if (context.getExecutionId() != null) {
            newIncident.createRecursiveIncidents();
        }
        return newIncident;
    }

    @Override
    public void resolveIncident(IncidentContext context) {
        this.removeIncident(context, true);
    }

    @Override
    public void deleteIncident(IncidentContext context) {
        this.removeIncident(context, false);
    }

    protected void removeIncident(IncidentContext context, boolean incidentResolved) {
        List<Incident> incidents = Context.getCommandContext().getIncidentManager().findIncidentByConfiguration(context.getConfiguration());
        for (Incident currentIncident : incidents) {
            IncidentEntity incident = (IncidentEntity)currentIncident;
            if (incidentResolved) {
                incident.resolve();
                continue;
            }
            incident.delete();
        }
    }
}

