/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.interceptor;

import org.eximeebpms.bpm.application.ProcessApplicationReference;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.interceptor.BpmnStackTrace;
import org.eximeebpms.bpm.engine.impl.interceptor.ContextLogger;
import org.eximeebpms.bpm.engine.impl.interceptor.ProcessDataContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.AtomicOperation;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;

public class AtomicOperationInvocation {
    private static final ContextLogger LOG = ProcessEngineLogger.CONTEXT_LOGGER;
    protected AtomicOperation operation;
    protected ExecutionEntity execution;
    protected boolean performAsync;
    protected String applicationContextName = null;
    protected String activityId = null;
    protected String activityName = null;

    public AtomicOperationInvocation(AtomicOperation operation, ExecutionEntity execution, boolean performAsync) {
        this.init(operation, execution, performAsync);
    }

    protected void init(AtomicOperation operation, ExecutionEntity execution, boolean performAsync) {
        this.operation = operation;
        this.execution = execution;
        this.performAsync = performAsync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(BpmnStackTrace stackTrace, ProcessDataContext processDataContext) {
        ExecutionEntity replacedBy;
        if (this.operation != PvmAtomicOperation.ACTIVITY_START_CANCEL_SCOPE && this.operation != PvmAtomicOperation.ACTIVITY_START_INTERRUPT_SCOPE && this.operation != PvmAtomicOperation.ACTIVITY_START_CONCURRENT && this.operation != PvmAtomicOperation.DELETE_CASCADE && (replacedBy = this.execution.getReplacedBy()) != null) {
            this.execution = replacedBy;
        }
        if (this.execution.isCanceled() && (this.operation == PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_END || this.operation == PvmAtomicOperation.ACTIVITY_NOTIFY_LISTENER_END)) {
            return;
        }
        if (this.execution.isEnded() && (this.operation == PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_TAKE || this.operation == PvmAtomicOperation.ACTIVITY_START_CREATE_SCOPE)) {
            return;
        }
        ProcessApplicationReference currentPa = Context.getCurrentProcessApplication();
        if (currentPa != null) {
            this.applicationContextName = currentPa.getName();
        }
        this.activityId = this.execution.getActivityId();
        this.activityName = this.execution.getCurrentActivityName();
        stackTrace.add(this);
        boolean popProcessDataContextSection = processDataContext.pushSection(this.execution);
        try {
            Context.setExecutionContext(this.execution);
            if (!this.performAsync) {
                LOG.debugExecutingAtomicOperation(this.operation, this.execution);
                this.operation.execute(this.execution);
            } else {
                this.execution.scheduleAtomicOperationAsync(this);
            }
            if (popProcessDataContextSection) {
                processDataContext.popSection();
            }
        }
        finally {
            Context.removeExecutionContext();
        }
    }

    public AtomicOperation getOperation() {
        return this.operation;
    }

    public ExecutionEntity getExecution() {
        return this.execution;
    }

    public boolean isPerformAsync() {
        return this.performAsync;
    }

    public String getApplicationContextName() {
        return this.applicationContextName;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getActivityName() {
        return this.activityName;
    }
}

