/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.interceptor;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cmd.CommandLogger;
import org.eximeebpms.bpm.engine.impl.interceptor.AbstractTransactionInterceptor;
import org.eximeebpms.bpm.engine.impl.interceptor.TransactionException;

public class JakartaTransactionInterceptor
extends AbstractTransactionInterceptor {
    protected static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected final TransactionManager transactionManager;

    public JakartaTransactionInterceptor(TransactionManager transactionManager, boolean requiresNew, ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(requiresNew, processEngineConfiguration);
        this.transactionManager = transactionManager;
    }

    @Override
    protected void doBegin() {
        try {
            this.transactionManager.begin();
        }
        catch (NotSupportedException e) {
            throw new TransactionException("Unable to begin transaction", e);
        }
        catch (SystemException e) {
            throw new TransactionException("Unable to begin transaction", e);
        }
    }

    @Override
    protected boolean isExisting() {
        try {
            return this.transactionManager.getStatus() != 6;
        }
        catch (SystemException e) {
            throw new TransactionException("Unable to retrieve transaction status", e);
        }
    }

    protected Transaction doSuspend() {
        try {
            return this.transactionManager.suspend();
        }
        catch (SystemException e) {
            throw new TransactionException("Unable to suspend transaction", e);
        }
    }

    @Override
    protected void doResume(Object tx) {
        if (tx != null) {
            try {
                this.transactionManager.resume((Transaction)tx);
            }
            catch (SystemException e) {
                throw new TransactionException("Unable to resume transaction", e);
            }
            catch (InvalidTransactionException e) {
                throw new TransactionException("Unable to resume transaction", e);
            }
        }
    }

    @Override
    protected void doCommit() {
        try {
            this.transactionManager.commit();
        }
        catch (HeuristicMixedException e) {
            throw new TransactionException("Unable to commit transaction", e);
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionException("Unable to commit transaction", e);
        }
        catch (RollbackException e) {
            this.handleRollbackException((Exception)((Object)e));
        }
        catch (SystemException e) {
            throw new TransactionException("Unable to commit transaction", e);
        }
        catch (RuntimeException e) {
            this.doRollback(true);
            throw e;
        }
        catch (Error e) {
            this.doRollback(true);
            throw e;
        }
    }

    @Override
    protected void doRollback(boolean isNew) {
        try {
            if (isNew) {
                this.transactionManager.rollback();
            } else {
                this.transactionManager.setRollbackOnly();
            }
        }
        catch (SystemException e) {
            LOG.exceptionWhileRollingBackTransaction((Exception)((Object)e));
        }
    }
}

