/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.jobexecutor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobAcquisitionContext;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobAcquisitionStrategy;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobExecutor;

public class BackoffJobAcquisitionStrategy
implements JobAcquisitionStrategy {
    public static long DEFAULT_EXECUTION_SATURATION_WAIT_TIME = 100L;
    protected long baseIdleWaitTime;
    protected float idleIncreaseFactor;
    protected int idleLevel;
    protected int maxIdleLevel;
    protected long maxIdleWaitTime;
    protected long baseBackoffWaitTime;
    protected float backoffIncreaseFactor;
    protected int backoffLevel;
    protected int maxBackoffLevel;
    protected long maxBackoffWaitTime;
    protected boolean applyJitter = false;
    protected int numAcquisitionsWithoutLockingFailure = 0;
    protected int backoffDecreaseThreshold;
    protected int baseNumJobsToAcquire;
    protected Map<String, Integer> jobsToAcquire = new HashMap<String, Integer>();
    protected boolean executionSaturated = false;
    protected long executionSaturationWaitTime = DEFAULT_EXECUTION_SATURATION_WAIT_TIME;

    public BackoffJobAcquisitionStrategy(long baseIdleWaitTime, float idleIncreaseFactor, long maxIdleTime, long baseBackoffWaitTime, float backoffIncreaseFactor, long maxBackoffTime, int backoffDecreaseThreshold, int baseNumJobsToAcquire) {
        this.baseIdleWaitTime = baseIdleWaitTime;
        this.idleIncreaseFactor = idleIncreaseFactor;
        this.idleLevel = 0;
        this.maxIdleWaitTime = maxIdleTime;
        this.baseBackoffWaitTime = baseBackoffWaitTime;
        this.backoffIncreaseFactor = backoffIncreaseFactor;
        this.backoffLevel = 0;
        this.maxBackoffWaitTime = maxBackoffTime;
        this.backoffDecreaseThreshold = backoffDecreaseThreshold;
        this.baseNumJobsToAcquire = baseNumJobsToAcquire;
        this.initializeMaxLevels();
    }

    public BackoffJobAcquisitionStrategy(JobExecutor jobExecutor) {
        this(jobExecutor.getWaitTimeInMillis(), jobExecutor.getWaitIncreaseFactor(), jobExecutor.getMaxWait(), jobExecutor.getBackoffTimeInMillis(), jobExecutor.getWaitIncreaseFactor(), jobExecutor.getMaxBackoff(), jobExecutor.getBackoffDecreaseThreshold(), jobExecutor.getMaxJobsPerAcquisition());
    }

    protected void initializeMaxLevels() {
        if (this.baseIdleWaitTime > 0L && this.maxIdleWaitTime > 0L && this.idleIncreaseFactor > 0.0f && this.maxIdleWaitTime >= this.baseIdleWaitTime) {
            this.maxIdleLevel = (int)this.log(this.idleIncreaseFactor, this.maxIdleWaitTime / this.baseIdleWaitTime) + 1;
            ++this.maxIdleLevel;
        } else {
            this.maxIdleLevel = 0;
        }
        if (this.baseBackoffWaitTime > 0L && this.maxBackoffWaitTime > 0L && this.backoffIncreaseFactor > 0.0f && this.maxBackoffWaitTime >= this.baseBackoffWaitTime) {
            this.maxBackoffLevel = (int)this.log(this.backoffIncreaseFactor, this.maxBackoffWaitTime / this.baseBackoffWaitTime) + 1;
            ++this.maxBackoffLevel;
        } else {
            this.maxBackoffLevel = 0;
        }
    }

    protected double log(double base, double value) {
        return Math.log10(value) / Math.log10(base);
    }

    @Override
    public void reconfigure(JobAcquisitionContext context) {
        this.reconfigureIdleLevel(context);
        this.reconfigureBackoffLevel(context);
        this.reconfigureNumberOfJobsToAcquire(context);
        this.executionSaturated = this.allSubmittedJobsRejected(context);
    }

    protected boolean allSubmittedJobsRejected(JobAcquisitionContext context) {
        for (Map.Entry<String, AcquiredJobs> acquiredJobsForEngine : context.getAcquiredJobsByEngine().entrySet()) {
            String engineName = acquiredJobsForEngine.getKey();
            List<List<String>> acquiredJobBatches = acquiredJobsForEngine.getValue().getJobIdBatches();
            List<List<String>> resubmittedJobBatches = context.getAdditionalJobsByEngine().get(engineName);
            List<List<String>> rejectedJobBatches = context.getRejectedJobsByEngine().get(engineName);
            int numJobsSubmittedForExecution = acquiredJobBatches.size();
            if (resubmittedJobBatches != null) {
                numJobsSubmittedForExecution += resubmittedJobBatches.size();
            }
            int numJobsRejected = 0;
            if (rejectedJobBatches != null) {
                numJobsRejected += rejectedJobBatches.size();
            }
            if (numJobsRejected != 0 && numJobsSubmittedForExecution <= numJobsRejected) continue;
            return false;
        }
        return true;
    }

    protected void reconfigureIdleLevel(JobAcquisitionContext context) {
        if (context.isJobAdded()) {
            this.idleLevel = 0;
        } else if (context.areAllEnginesIdle() || context.getAcquisitionException() != null) {
            if (this.idleLevel < this.maxIdleLevel) {
                ++this.idleLevel;
            }
        } else {
            this.idleLevel = 0;
        }
    }

    protected void reconfigureBackoffLevel(JobAcquisitionContext context) {
        if (context.hasJobAcquisitionLockFailureOccurred()) {
            this.numAcquisitionsWithoutLockingFailure = 0;
            this.applyJitter = true;
            if (this.backoffLevel < this.maxBackoffLevel) {
                ++this.backoffLevel;
            }
        } else {
            this.applyJitter = false;
            ++this.numAcquisitionsWithoutLockingFailure;
            if (this.numAcquisitionsWithoutLockingFailure >= this.backoffDecreaseThreshold && this.backoffLevel > 0) {
                --this.backoffLevel;
                this.numAcquisitionsWithoutLockingFailure = 0;
            }
        }
    }

    protected void reconfigureNumberOfJobsToAcquire(JobAcquisitionContext context) {
        this.jobsToAcquire.clear();
        for (Map.Entry<String, AcquiredJobs> acquiredJobsEntry : context.getAcquiredJobsByEngine().entrySet()) {
            String engineName = acquiredJobsEntry.getKey();
            int numJobsToAcquire = (int)((double)this.baseNumJobsToAcquire * Math.pow(this.backoffIncreaseFactor, this.backoffLevel));
            List<List<String>> rejectedJobBatchesForEngine = context.getRejectedJobsByEngine().get(engineName);
            if (rejectedJobBatchesForEngine != null) {
                numJobsToAcquire -= rejectedJobBatchesForEngine.size();
            }
            numJobsToAcquire = Math.max(0, numJobsToAcquire);
            this.jobsToAcquire.put(engineName, numJobsToAcquire);
        }
    }

    @Override
    public long getWaitTime() {
        if (this.idleLevel > 0) {
            return this.calculateIdleTime();
        }
        if (this.backoffLevel > 0) {
            return this.calculateBackoffTime();
        }
        if (this.executionSaturated) {
            return this.executionSaturationWaitTime;
        }
        return 0L;
    }

    protected long calculateIdleTime() {
        if (this.idleLevel <= 0) {
            return 0L;
        }
        if (this.idleLevel >= this.maxIdleLevel) {
            return this.maxIdleWaitTime;
        }
        return (long)((double)this.baseIdleWaitTime * Math.pow(this.idleIncreaseFactor, this.idleLevel - 1));
    }

    protected long calculateBackoffTime() {
        long backoffTime = 0L;
        backoffTime = this.backoffLevel <= 0 ? 0L : (this.backoffLevel >= this.maxBackoffLevel ? this.maxBackoffWaitTime : (long)((double)this.baseBackoffWaitTime * Math.pow(this.backoffIncreaseFactor, this.backoffLevel - 1)));
        if (this.applyJitter) {
            backoffTime = (long)((double)backoffTime + Math.random() * (double)(backoffTime / 2L));
        }
        return backoffTime;
    }

    @Override
    public int getNumJobsToAcquire(String processEngine) {
        Integer numJobsToAcquire = this.jobsToAcquire.get(processEngine);
        if (numJobsToAcquire != null) {
            return numJobsToAcquire;
        }
        return this.baseNumJobsToAcquire;
    }
}

