/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.jobexecutor;

import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobHandler;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import org.eximeebpms.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;

public class ProcessEventJobHandler
implements JobHandler<EventSubscriptionJobConfiguration> {
    public static final String TYPE = "event";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(EventSubscriptionJobConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        String eventSubscriptionId = configuration.getEventSubscriptionId();
        EventSubscriptionEntity eventSubscription = commandContext.getEventSubscriptionManager().findEventSubscriptionById(eventSubscriptionId);
        if (eventSubscription != null) {
            eventSubscription.eventReceived(null, false);
        }
    }

    @Override
    public EventSubscriptionJobConfiguration newConfiguration(String canonicalString) {
        return new EventSubscriptionJobConfiguration(canonicalString);
    }

    @Override
    public void onDelete(EventSubscriptionJobConfiguration configuration, JobEntity jobEntity) {
    }

    public static class EventSubscriptionJobConfiguration
    implements JobHandlerConfiguration {
        protected String eventSubscriptionId;

        public EventSubscriptionJobConfiguration(String eventSubscriptionId) {
            this.eventSubscriptionId = eventSubscriptionId;
        }

        public String getEventSubscriptionId() {
            return this.eventSubscriptionId;
        }

        @Override
        public String toCanonicalString() {
            return this.eventSubscriptionId;
        }
    }
}

