/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.jobexecutor;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.delegate.Expression;
import org.eximeebpms.bpm.engine.delegate.VariableScope;
import org.eximeebpms.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.eximeebpms.bpm.engine.impl.calendar.BusinessCalendar;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.el.StartProcessVariableScope;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import org.eximeebpms.bpm.engine.impl.jobexecutor.TimerDeclarationType;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.TimerEntity;
import org.eximeebpms.bpm.engine.impl.pvm.PvmScope;

public class TimerDeclarationImpl
extends JobDeclaration<ExecutionEntity, TimerEntity> {
    private static final long serialVersionUID = 1L;
    protected Expression description;
    protected TimerDeclarationType type;
    protected String repeat;
    protected boolean isInterruptingTimer;
    protected String eventScopeActivityId = null;
    protected Boolean isParallelMultiInstance;
    protected String rawJobHandlerConfiguration;

    public TimerDeclarationImpl(Expression expression, TimerDeclarationType type, String jobHandlerType) {
        super(jobHandlerType);
        this.description = expression;
        this.type = type;
    }

    public boolean isInterruptingTimer() {
        return this.isInterruptingTimer;
    }

    public void setInterruptingTimer(boolean isInterruptingTimer) {
        this.isInterruptingTimer = isInterruptingTimer;
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setEventScopeActivityId(String eventScopeActivityId) {
        this.eventScopeActivityId = eventScopeActivityId;
    }

    public String getEventScopeActivityId() {
        return this.eventScopeActivityId;
    }

    @Override
    protected TimerEntity newJobInstance(ExecutionEntity execution) {
        TimerEntity timer = new TimerEntity(this);
        if (execution != null) {
            timer.setExecution(execution);
        }
        return timer;
    }

    public void setRawJobHandlerConfiguration(String rawJobHandlerConfiguration) {
        this.rawJobHandlerConfiguration = rawJobHandlerConfiguration;
    }

    public void updateJob(TimerEntity timer) {
        this.initializeConfiguration(timer.getExecution(), timer);
    }

    protected void initializeConfiguration(ExecutionEntity context, TimerEntity job) {
        String dueDateString = this.resolveAndSetDuedate(context, job, false);
        if (this.type == TimerDeclarationType.CYCLE && this.jobHandlerType != "timer-intermediate-transition" && !this.isInterruptingTimer) {
            String prepared = this.prepareRepeat(dueDateString);
            job.setRepeat(prepared);
        }
    }

    public String resolveAndSetDuedate(ExecutionEntity context, TimerEntity job, boolean creationDateBased) {
        Object dueDateValue;
        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(this.type.calendarName);
        if (this.description == null) {
            throw new ProcessEngineException("Timer '" + context.getActivityId() + "' was not configured with a valid duration/time");
        }
        String dueDateString = null;
        Date duedate = null;
        VariableScope scopeForExpression = context;
        if (scopeForExpression == null) {
            scopeForExpression = StartProcessVariableScope.getSharedInstance();
        }
        if ((dueDateValue = this.description.getValue(scopeForExpression)) instanceof String) {
            dueDateString = (String)dueDateValue;
        } else if (dueDateValue instanceof Date) {
            duedate = (Date)dueDateValue;
        } else {
            throw new ProcessEngineException("Timer '" + context.getActivityId() + "' was not configured with a valid duration/time, either hand in a java.util.Date or a String in format 'yyyy-MM-dd'T'hh:mm:ss'");
        }
        if (duedate == null) {
            if (creationDateBased) {
                if (job.getCreateTime() == null) {
                    throw new ProcessEngineException("Timer '" + context.getActivityId() + "' has no creation time and cannot be recalculated based on creation date. Either recalculate on your own or trigger recalculation with creationDateBased set to false.");
                }
                duedate = businessCalendar.resolveDuedate(dueDateString, job.getCreateTime());
            } else {
                duedate = businessCalendar.resolveDuedate(dueDateString);
            }
        }
        job.setDuedate(duedate);
        return dueDateString;
    }

    @Override
    protected void postInitialize(ExecutionEntity execution, TimerEntity timer) {
        this.initializeConfiguration(execution, timer);
    }

    protected String prepareRepeat(String dueDate) {
        if (dueDate.startsWith("R")) {
            return TimerEntity.replaceRepeatCycleAndDate(dueDate);
        }
        return dueDate;
    }

    public TimerEntity createTimerInstance(ExecutionEntity execution) {
        return this.createTimer(execution);
    }

    public TimerEntity createStartTimerInstance(String deploymentId) {
        return this.createTimer(deploymentId);
    }

    public TimerEntity createTimer(String deploymentId) {
        TimerEntity timer = (TimerEntity)super.createJobInstance(null);
        timer.setDeploymentId(deploymentId);
        this.scheduleTimer(timer);
        return timer;
    }

    public TimerEntity createTimer(ExecutionEntity execution) {
        TimerEntity timer = (TimerEntity)super.createJobInstance(execution);
        this.scheduleTimer(timer);
        return timer;
    }

    protected void scheduleTimer(TimerEntity timer) {
        Context.getCommandContext().getJobManager().schedule(timer);
    }

    @Override
    protected ExecutionEntity resolveExecution(ExecutionEntity context) {
        return context;
    }

    @Override
    protected JobHandlerConfiguration resolveJobHandlerConfiguration(ExecutionEntity context) {
        return this.resolveJobHandler().newConfiguration(this.rawJobHandlerConfiguration);
    }

    public static Map<String, TimerDeclarationImpl> getDeclarationsForScope(PvmScope scope) {
        if (scope == null) {
            return Collections.emptyMap();
        }
        Map<String, TimerDeclarationImpl> result = scope.getProperties().get(BpmnProperties.TIMER_DECLARATIONS);
        if (result != null) {
            return result;
        }
        return Collections.emptyMap();
    }

    public static Map<String, Map<String, TimerDeclarationImpl>> getTimeoutListenerDeclarationsForScope(PvmScope scope) {
        if (scope == null) {
            return Collections.emptyMap();
        }
        Map<String, Map<String, TimerDeclarationImpl>> result = scope.getProperties().get(BpmnProperties.TIMEOUT_LISTENER_DECLARATIONS);
        if (result != null) {
            return result;
        }
        return Collections.emptyMap();
    }
}

