/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.jobexecutor;

import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobHandler;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;

public abstract class TimerEventJobHandler
implements JobHandler<TimerJobConfiguration> {
    public static final String JOB_HANDLER_CONFIG_PROPERTY_DELIMITER = "$";
    public static final String JOB_HANDLER_CONFIG_PROPERTY_FOLLOW_UP_JOB_CREATED = "followUpJobCreated";
    public static final String JOB_HANDLER_CONFIG_TASK_LISTENER_PREFIX = "taskListener~";

    @Override
    public TimerJobConfiguration newConfiguration(String canonicalString) {
        String[] configParts = canonicalString.split("\\$");
        if (configParts.length > 3) {
            throw new ProcessEngineException("Illegal timer job handler configuration: '" + canonicalString + "': exprecting a one, two or three part configuration seperated by '$'.");
        }
        TimerJobConfiguration configuration = new TimerJobConfiguration();
        configuration.timerElementKey = configParts[0];
        for (int i = 1; i < configParts.length; ++i) {
            this.adjustConfiguration(configuration, configParts[i]);
        }
        return configuration;
    }

    protected void adjustConfiguration(TimerJobConfiguration configuration, String configPart) {
        if (configPart.startsWith(JOB_HANDLER_CONFIG_TASK_LISTENER_PREFIX)) {
            configuration.setTimerElementSecondaryKey(configPart.substring(JOB_HANDLER_CONFIG_TASK_LISTENER_PREFIX.length()));
        } else {
            configuration.followUpJobCreated = JOB_HANDLER_CONFIG_PROPERTY_FOLLOW_UP_JOB_CREATED.equals(configPart);
        }
    }

    @Override
    public void onDelete(TimerJobConfiguration configuration, JobEntity jobEntity) {
    }

    public static class TimerJobConfiguration
    implements JobHandlerConfiguration {
        protected String timerElementKey;
        protected String timerElementSecondaryKey;
        protected boolean followUpJobCreated;

        public String getTimerElementKey() {
            return this.timerElementKey;
        }

        public void setTimerElementKey(String timerElementKey) {
            this.timerElementKey = timerElementKey;
        }

        public boolean isFollowUpJobCreated() {
            return this.followUpJobCreated;
        }

        public void setFollowUpJobCreated(boolean followUpJobCreated) {
            this.followUpJobCreated = followUpJobCreated;
        }

        public String getTimerElementSecondaryKey() {
            return this.timerElementSecondaryKey;
        }

        public void setTimerElementSecondaryKey(String timerElementSecondaryKey) {
            this.timerElementSecondaryKey = timerElementSecondaryKey;
        }

        @Override
        public String toCanonicalString() {
            Object canonicalString = this.timerElementKey;
            if (this.timerElementSecondaryKey != null) {
                canonicalString = (String)canonicalString + "$taskListener~" + this.timerElementSecondaryKey;
            }
            if (this.followUpJobCreated) {
                canonicalString = (String)canonicalString + "$followUpJobCreated";
            }
            return canonicalString;
        }
    }
}

