/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.jobexecutor.historycleanup;

import java.util.Calendar;
import java.util.Date;
import org.eximeebpms.bpm.engine.impl.cfg.BatchWindowConfiguration;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.jobexecutor.historycleanup.BatchWindow;
import org.eximeebpms.bpm.engine.impl.jobexecutor.historycleanup.BatchWindowManager;

public class DefaultBatchWindowManager
implements BatchWindowManager {
    public BatchWindow getPreviousDayBatchWindow(Date date, ProcessEngineConfigurationImpl configuration) {
        Date previousDay = DefaultBatchWindowManager.addDays(date, -1);
        return this.getBatchWindowForDate(previousDay, configuration);
    }

    private BatchWindow getBatchWindowForDate(Date date, ProcessEngineConfigurationImpl configuration) {
        BatchWindowConfiguration batchWindowConfiguration = configuration.getHistoryCleanupBatchWindows().get(this.dayOfWeek(date));
        if (batchWindowConfiguration == null && configuration.getHistoryCleanupBatchWindowStartTime() != null) {
            batchWindowConfiguration = new BatchWindowConfiguration(configuration.getHistoryCleanupBatchWindowStartTime(), configuration.getHistoryCleanupBatchWindowEndTime());
        }
        if (batchWindowConfiguration == null) {
            return null;
        }
        Date startTime = DefaultBatchWindowManager.updateTime(date, batchWindowConfiguration.getStartTimeAsDate());
        Date endTime = DefaultBatchWindowManager.updateTime(date, batchWindowConfiguration.getEndTimeAsDate());
        if (!endTime.after(startTime)) {
            endTime = DefaultBatchWindowManager.addDays(endTime, 1);
        }
        return new BatchWindow(startTime, endTime);
    }

    private Integer dayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7);
    }

    @Override
    public BatchWindow getCurrentOrNextBatchWindow(Date date, ProcessEngineConfigurationImpl configuration) {
        BatchWindow previousDayBatchWindow = this.getPreviousDayBatchWindow(date, configuration);
        if (previousDayBatchWindow != null && previousDayBatchWindow.isWithin(date)) {
            return previousDayBatchWindow;
        }
        BatchWindow currentDayBatchWindow = this.getBatchWindowForDate(date, configuration);
        if (currentDayBatchWindow != null && (currentDayBatchWindow.isWithin(date) || date.before(currentDayBatchWindow.getStart()))) {
            return currentDayBatchWindow;
        }
        for (int i = 1; i <= 7; ++i) {
            Date dateToCheck = DefaultBatchWindowManager.addDays(date, i);
            BatchWindow batchWindowForDate = this.getBatchWindowForDate(dateToCheck, configuration);
            if (batchWindowForDate == null) continue;
            return batchWindowForDate;
        }
        return null;
    }

    @Override
    public BatchWindow getNextBatchWindow(Date date, ProcessEngineConfigurationImpl configuration) {
        BatchWindow currentDayBatchWindow = this.getBatchWindowForDate(date, configuration);
        if (currentDayBatchWindow != null && date.before(currentDayBatchWindow.getStart())) {
            return currentDayBatchWindow;
        }
        for (int i = 1; i <= 7; ++i) {
            Date dateToCheck = DefaultBatchWindowManager.addDays(date, i);
            BatchWindow batchWindowForDate = this.getBatchWindowForDate(dateToCheck, configuration);
            if (batchWindowForDate == null) continue;
            return batchWindowForDate;
        }
        return null;
    }

    @Override
    public boolean isBatchWindowConfigured(ProcessEngineConfigurationImpl configuration) {
        return configuration.getHistoryCleanupBatchWindowStartTimeAsDate() != null || !configuration.getHistoryCleanupBatchWindows().isEmpty();
    }

    private static Date updateTime(Date now, Date newTime) {
        Calendar c = Calendar.getInstance();
        c.setTime(now);
        Calendar newTimeCalendar = Calendar.getInstance();
        newTimeCalendar.setTime(newTime);
        c.set(15, newTimeCalendar.get(15));
        c.set(16, newTimeCalendar.get(16));
        c.set(11, newTimeCalendar.get(11));
        c.set(12, newTimeCalendar.get(12));
        c.set(13, newTimeCalendar.get(13));
        c.set(14, newTimeCalendar.get(14));
        return c.getTime();
    }

    private static Date addDays(Date date, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, amount);
        return c.getTime();
    }
}

