/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.json;

import eximeebpms.impl.com.google.gson.JsonObject;
import java.util.List;
import org.eximeebpms.bpm.engine.impl.batch.AbstractBatchConfigurationObjectConverter;
import org.eximeebpms.bpm.engine.impl.batch.DeploymentMappingJsonConverter;
import org.eximeebpms.bpm.engine.impl.batch.DeploymentMappings;
import org.eximeebpms.bpm.engine.impl.json.MigrationPlanJsonConverter;
import org.eximeebpms.bpm.engine.impl.migration.batch.MigrationBatchConfiguration;
import org.eximeebpms.bpm.engine.impl.util.JsonUtil;

public class MigrationBatchConfigurationJsonConverter
extends AbstractBatchConfigurationObjectConverter<MigrationBatchConfiguration> {
    public static final MigrationBatchConfigurationJsonConverter INSTANCE = new MigrationBatchConfigurationJsonConverter();
    public static final String MIGRATION_PLAN = "migrationPlan";
    public static final String PROCESS_INSTANCE_IDS = "processInstanceIds";
    public static final String PROCESS_INSTANCE_ID_MAPPINGS = "processInstanceIdMappings";
    public static final String SKIP_LISTENERS = "skipListeners";
    public static final String SKIP_IO_MAPPINGS = "skipIoMappings";

    @Override
    public JsonObject writeConfiguration(MigrationBatchConfiguration configuration) {
        JsonObject json = JsonUtil.createObject();
        JsonUtil.addField(json, MIGRATION_PLAN, MigrationPlanJsonConverter.INSTANCE, configuration.getMigrationPlan());
        JsonUtil.addListField(json, PROCESS_INSTANCE_IDS, configuration.getIds());
        JsonUtil.addListField(json, PROCESS_INSTANCE_ID_MAPPINGS, DeploymentMappingJsonConverter.INSTANCE, configuration.getIdMappings());
        JsonUtil.addField(json, SKIP_LISTENERS, configuration.isSkipCustomListeners());
        JsonUtil.addField(json, SKIP_IO_MAPPINGS, configuration.isSkipIoMappings());
        return json;
    }

    @Override
    public MigrationBatchConfiguration readConfiguration(JsonObject json) {
        return new MigrationBatchConfiguration(this.readProcessInstanceIds(json), this.readIdMappings(json), JsonUtil.asJavaObject(JsonUtil.getObject(json, MIGRATION_PLAN), MigrationPlanJsonConverter.INSTANCE), JsonUtil.getBoolean(json, SKIP_LISTENERS), JsonUtil.getBoolean(json, SKIP_IO_MAPPINGS));
    }

    protected List<String> readProcessInstanceIds(JsonObject jsonObject) {
        return JsonUtil.asStringList(JsonUtil.getArray(jsonObject, PROCESS_INSTANCE_IDS));
    }

    protected DeploymentMappings readIdMappings(JsonObject json) {
        return JsonUtil.asList(JsonUtil.getArray(json, PROCESS_INSTANCE_ID_MAPPINGS), DeploymentMappingJsonConverter.INSTANCE, DeploymentMappings::new);
    }
}

