/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.metrics.parser;

import java.util.function.Function;
import org.eximeebpms.bpm.engine.delegate.DelegateExecution;
import org.eximeebpms.bpm.engine.delegate.ExecutionListener;
import org.eximeebpms.bpm.engine.impl.context.Context;

public class MetricsExecutionListener
implements ExecutionListener {
    protected String metricsName;
    protected Function<DelegateExecution, Boolean> condition;

    public MetricsExecutionListener(String metricsName) {
        this(metricsName, delegateExecution -> true);
    }

    public MetricsExecutionListener(String metricsName, Function<DelegateExecution, Boolean> condition) {
        this.metricsName = metricsName;
        this.condition = condition;
    }

    @Override
    public void notify(DelegateExecution execution) throws Exception {
        if (this.condition.apply(execution).booleanValue()) {
            Context.getProcessEngineConfiguration().getMetricsRegistry().markOccurrence(this.metricsName);
        }
    }
}

