/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.migration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.eximeebpms.bpm.engine.impl.db.CompositePermissionCheck;
import org.eximeebpms.bpm.engine.impl.db.PermissionCheckBuilder;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.migration.MigrationPlanExecutionBuilderImpl;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.PropertyChange;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public abstract class AbstractMigrationCmd {
    protected MigrationPlanExecutionBuilderImpl executionBuilder;

    public AbstractMigrationCmd(MigrationPlanExecutionBuilderImpl executionBuilder) {
        this.executionBuilder = executionBuilder;
    }

    protected void checkAuthorizations(CommandContext commandContext, ProcessDefinitionEntity sourceDefinition, ProcessDefinitionEntity targetDefinition) {
        CompositePermissionCheck migrateInstanceCheck = new PermissionCheckBuilder().conjunctive().atomicCheckForResourceId(Resources.PROCESS_DEFINITION, sourceDefinition.getKey(), Permissions.MIGRATE_INSTANCE).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, targetDefinition.getKey(), Permissions.MIGRATE_INSTANCE).build();
        commandContext.getAuthorizationManager().checkAuthorization(migrateInstanceCheck);
    }

    protected Collection<String> collectProcessInstanceIds() {
        ProcessInstanceQueryImpl processInstanceQuery;
        HashSet<String> collectedProcessInstanceIds = new HashSet<String>();
        List<String> processInstanceIds = this.executionBuilder.getProcessInstanceIds();
        if (processInstanceIds != null) {
            collectedProcessInstanceIds.addAll(processInstanceIds);
        }
        if ((processInstanceQuery = (ProcessInstanceQueryImpl)this.executionBuilder.getProcessInstanceQuery()) != null) {
            collectedProcessInstanceIds.addAll(processInstanceQuery.listIds());
        }
        return collectedProcessInstanceIds;
    }

    protected void writeUserOperationLog(CommandContext commandContext, ProcessDefinitionEntity sourceProcessDefinition, ProcessDefinitionEntity targetProcessDefinition, int numInstances, Map<String, Object> variables, boolean async) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("processDefinitionId", sourceProcessDefinition.getId(), targetProcessDefinition.getId()));
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        if (variables != null) {
            propertyChanges.add(new PropertyChange("nrOfSetVariables", null, variables.size()));
        }
        propertyChanges.add(new PropertyChange("async", null, async));
        commandContext.getOperationLogManager().logProcessInstanceOperation("Migrate", null, sourceProcessDefinition.getId(), sourceProcessDefinition.getKey(), propertyChanges);
    }

    protected ProcessDefinitionEntity resolveSourceProcessDefinition(CommandContext commandContext) {
        String sourceProcessDefinitionId = this.executionBuilder.getMigrationPlan().getSourceProcessDefinitionId();
        ProcessDefinitionEntity sourceProcessDefinition = this.getProcessDefinition(commandContext, sourceProcessDefinitionId);
        EnsureUtil.ensureNotNull("sourceProcessDefinition", (Object)sourceProcessDefinition);
        return sourceProcessDefinition;
    }

    protected ProcessDefinitionEntity resolveTargetProcessDefinition(CommandContext commandContext) {
        String targetProcessDefinitionId = this.executionBuilder.getMigrationPlan().getTargetProcessDefinitionId();
        ProcessDefinitionEntity sourceProcessDefinition = this.getProcessDefinition(commandContext, targetProcessDefinitionId);
        EnsureUtil.ensureNotNull("sourceProcessDefinition", (Object)sourceProcessDefinition);
        return sourceProcessDefinition;
    }

    protected ProcessDefinitionEntity getProcessDefinition(CommandContext commandContext, String processDefinitionId) {
        return commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(processDefinitionId);
    }
}

