/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.migration.batch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.impl.batch.AbstractBatchJobHandler;
import org.eximeebpms.bpm.engine.impl.batch.BatchJobContext;
import org.eximeebpms.bpm.engine.impl.batch.BatchJobDeclaration;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.core.variable.VariableUtil;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.eximeebpms.bpm.engine.impl.json.MigrationBatchConfigurationJsonConverter;
import org.eximeebpms.bpm.engine.impl.migration.MigrateProcessInstanceCmd;
import org.eximeebpms.bpm.engine.impl.migration.MigrationPlanExecutionBuilderImpl;
import org.eximeebpms.bpm.engine.impl.migration.MigrationPlanImpl;
import org.eximeebpms.bpm.engine.impl.migration.batch.MigrationBatchConfiguration;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.MessageEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.eximeebpms.bpm.engine.migration.MigrationPlanExecutionBuilder;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.impl.VariableMapImpl;

public class MigrationBatchJobHandler
extends AbstractBatchJobHandler<MigrationBatchConfiguration> {
    public static final BatchJobDeclaration JOB_DECLARATION = new BatchJobDeclaration("instance-migration");

    @Override
    public String getType() {
        return "instance-migration";
    }

    @Override
    public JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    protected MigrationBatchConfigurationJsonConverter getJsonConverterInstance() {
        return MigrationBatchConfigurationJsonConverter.INSTANCE;
    }

    @Override
    protected MigrationBatchConfiguration createJobConfiguration(MigrationBatchConfiguration configuration, List<String> processIdsForJob) {
        return new MigrationBatchConfiguration(processIdsForJob, configuration.getMigrationPlan(), configuration.isSkipCustomListeners(), configuration.isSkipIoMappings(), configuration.getBatchId());
    }

    @Override
    protected void postProcessJob(MigrationBatchConfiguration configuration, JobEntity job, MigrationBatchConfiguration jobConfiguration) {
        if (job.getDeploymentId() == null) {
            CommandContext commandContext = Context.getCommandContext();
            String sourceProcessDefinitionId = configuration.getMigrationPlan().getSourceProcessDefinitionId();
            ProcessDefinitionEntity processDefinition = this.getProcessDefinition(commandContext, sourceProcessDefinitionId);
            job.setDeploymentId(processDefinition.getDeploymentId());
        }
    }

    @Override
    public void executeHandler(MigrationBatchConfiguration batchConfiguration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        MigrationPlanImpl migrationPlan = (MigrationPlanImpl)batchConfiguration.getMigrationPlan();
        String batchId = batchConfiguration.getBatchId();
        this.setVariables(batchId, migrationPlan, commandContext);
        MigrationPlanExecutionBuilder executionBuilder = commandContext.getProcessEngineConfiguration().getRuntimeService().newMigration(migrationPlan).processInstanceIds(batchConfiguration.getIds());
        if (batchConfiguration.isSkipCustomListeners()) {
            executionBuilder.skipCustomListeners();
        }
        if (batchConfiguration.isSkipIoMappings()) {
            executionBuilder.skipIoMappings();
        }
        commandContext.executeWithOperationLogPrevented(new MigrateProcessInstanceCmd((MigrationPlanExecutionBuilderImpl)executionBuilder, true));
    }

    protected void setVariables(String batchId, MigrationPlanImpl migrationPlan, CommandContext commandContext) {
        Map<String, ?> variables = null;
        if (batchId != null && (variables = VariableUtil.findBatchVariablesSerialized(batchId, commandContext)) != null) {
            migrationPlan.setVariables((VariableMap)new VariableMapImpl(new HashMap(variables)));
        }
    }

    protected ProcessDefinitionEntity getProcessDefinition(CommandContext commandContext, String processDefinitionId) {
        return commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(processDefinitionId);
    }
}

