/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.migration.instance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.migration.MigrationLogger;
import org.eximeebpms.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.eximeebpms.bpm.engine.impl.migration.instance.MigratingCompensationEventSubscriptionInstance;
import org.eximeebpms.bpm.engine.impl.migration.instance.MigratingEventScopeInstance;
import org.eximeebpms.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import org.eximeebpms.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import org.eximeebpms.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.pvm.process.ScopeImpl;
import org.eximeebpms.bpm.engine.migration.MigrationInstruction;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.TransitionInstance;

public class MigratingProcessInstance {
    protected static final MigrationLogger LOGGER = ProcessEngineLogger.MIGRATION_LOGGER;
    protected String processInstanceId;
    protected List<MigratingActivityInstance> migratingActivityInstances;
    protected List<MigratingTransitionInstance> migratingTransitionInstances;
    protected List<MigratingEventScopeInstance> migratingEventScopeInstances;
    protected List<MigratingCompensationEventSubscriptionInstance> migratingCompensationSubscriptionInstances;
    protected MigratingActivityInstance rootInstance;
    protected ProcessDefinitionEntity sourceDefinition;
    protected ProcessDefinitionEntity targetDefinition;

    public MigratingProcessInstance(String processInstanceId, ProcessDefinitionEntity sourceDefinition, ProcessDefinitionEntity targetDefinition) {
        this.processInstanceId = processInstanceId;
        this.migratingActivityInstances = new ArrayList<MigratingActivityInstance>();
        this.migratingTransitionInstances = new ArrayList<MigratingTransitionInstance>();
        this.migratingEventScopeInstances = new ArrayList<MigratingEventScopeInstance>();
        this.migratingCompensationSubscriptionInstances = new ArrayList<MigratingCompensationEventSubscriptionInstance>();
        this.sourceDefinition = sourceDefinition;
        this.targetDefinition = targetDefinition;
    }

    public MigratingActivityInstance getRootInstance() {
        return this.rootInstance;
    }

    public void setRootInstance(MigratingActivityInstance rootInstance) {
        this.rootInstance = rootInstance;
    }

    public Collection<MigratingActivityInstance> getMigratingActivityInstances() {
        return this.migratingActivityInstances;
    }

    public Collection<MigratingTransitionInstance> getMigratingTransitionInstances() {
        return this.migratingTransitionInstances;
    }

    public Collection<MigratingEventScopeInstance> getMigratingEventScopeInstances() {
        return this.migratingEventScopeInstances;
    }

    public Collection<MigratingCompensationEventSubscriptionInstance> getMigratingCompensationSubscriptionInstances() {
        return this.migratingCompensationSubscriptionInstances;
    }

    public Collection<MigratingScopeInstance> getMigratingScopeInstances() {
        HashSet<MigratingScopeInstance> result = new HashSet<MigratingScopeInstance>();
        result.addAll(this.migratingActivityInstances);
        result.addAll(this.migratingEventScopeInstances);
        return result;
    }

    public ProcessDefinitionEntity getSourceDefinition() {
        return this.sourceDefinition;
    }

    public ProcessDefinitionEntity getTargetDefinition() {
        return this.targetDefinition;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public MigratingActivityInstance addActivityInstance(MigrationInstruction migrationInstruction, ActivityInstance activityInstance, ScopeImpl sourceScope, ScopeImpl targetScope, ExecutionEntity scopeExecution) {
        MigratingActivityInstance migratingActivityInstance = new MigratingActivityInstance(activityInstance, migrationInstruction, sourceScope, targetScope, scopeExecution);
        this.migratingActivityInstances.add(migratingActivityInstance);
        if (this.processInstanceId.equals(activityInstance.getId())) {
            this.rootInstance = migratingActivityInstance;
        }
        return migratingActivityInstance;
    }

    public MigratingTransitionInstance addTransitionInstance(MigrationInstruction migrationInstruction, TransitionInstance transitionInstance, ScopeImpl sourceScope, ScopeImpl targetScope, ExecutionEntity asyncExecution) {
        MigratingTransitionInstance migratingTransitionInstance = new MigratingTransitionInstance(transitionInstance, migrationInstruction, sourceScope, targetScope, asyncExecution);
        this.migratingTransitionInstances.add(migratingTransitionInstance);
        return migratingTransitionInstance;
    }

    public MigratingEventScopeInstance addEventScopeInstance(MigrationInstruction migrationInstruction, ExecutionEntity eventScopeExecution, ScopeImpl sourceScope, ScopeImpl targetScope, MigrationInstruction eventSubscriptionInstruction, EventSubscriptionEntity eventSubscription, ScopeImpl eventSubscriptionSourceScope, ScopeImpl eventSubscriptionTargetScope) {
        MigratingEventScopeInstance compensationInstance = new MigratingEventScopeInstance(migrationInstruction, eventScopeExecution, sourceScope, targetScope, eventSubscriptionInstruction, eventSubscription, eventSubscriptionSourceScope, eventSubscriptionTargetScope);
        this.migratingEventScopeInstances.add(compensationInstance);
        return compensationInstance;
    }

    public MigratingCompensationEventSubscriptionInstance addCompensationSubscriptionInstance(MigrationInstruction eventSubscriptionInstruction, EventSubscriptionEntity eventSubscription, ScopeImpl sourceScope, ScopeImpl targetScope) {
        MigratingCompensationEventSubscriptionInstance compensationInstance = new MigratingCompensationEventSubscriptionInstance(eventSubscriptionInstruction, sourceScope, targetScope, eventSubscription);
        this.migratingCompensationSubscriptionInstances.add(compensationInstance);
        return compensationInstance;
    }
}

