/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.migration.instance.parser;

import org.eximeebpms.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.eximeebpms.bpm.engine.impl.migration.instance.MigratingExternalTaskInstance;
import org.eximeebpms.bpm.engine.impl.migration.instance.MigratingIncident;
import org.eximeebpms.bpm.engine.impl.migration.instance.MigratingJobInstance;
import org.eximeebpms.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import org.eximeebpms.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseHandler;
import org.eximeebpms.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobDefinitionEntity;

public class IncidentInstanceHandler
implements MigratingInstanceParseHandler<IncidentEntity> {
    @Override
    public void handle(MigratingInstanceParseContext parseContext, IncidentEntity incident) {
        if (incident.getConfiguration() != null && this.isFailedJobIncident(incident)) {
            this.handleFailedJobIncident(parseContext, incident);
        } else if (incident.getConfiguration() != null && this.isExternalTaskIncident(incident)) {
            this.handleExternalTaskIncident(parseContext, incident);
        } else {
            this.handleIncident(parseContext, incident);
        }
    }

    protected void handleIncident(MigratingInstanceParseContext parseContext, IncidentEntity incident) {
        MigratingActivityInstance owningInstance = parseContext.getMigratingActivityInstanceById(incident.getExecution().getActivityInstanceId());
        if (owningInstance != null) {
            parseContext.consume(incident);
            MigratingIncident migratingIncident = new MigratingIncident(incident, owningInstance.getTargetScope());
            owningInstance.addMigratingDependentInstance(migratingIncident);
        }
    }

    protected boolean isFailedJobIncident(IncidentEntity incident) {
        return "failedJob".equals(incident.getIncidentType());
    }

    protected void handleFailedJobIncident(MigratingInstanceParseContext parseContext, IncidentEntity incident) {
        MigratingJobInstance owningInstance = parseContext.getMigratingJobInstanceById(incident.getConfiguration());
        if (owningInstance != null) {
            parseContext.consume(incident);
            if (owningInstance.migrates()) {
                MigratingIncident migratingIncident = new MigratingIncident(incident, owningInstance.getTargetScope());
                JobDefinitionEntity targetJobDefinitionEntity = owningInstance.getTargetJobDefinitionEntity();
                if (targetJobDefinitionEntity != null) {
                    migratingIncident.setTargetJobDefinitionId(targetJobDefinitionEntity.getId());
                }
                owningInstance.addMigratingDependentInstance(migratingIncident);
            }
        }
    }

    protected boolean isExternalTaskIncident(IncidentEntity incident) {
        return "failedExternalTask".equals(incident.getIncidentType());
    }

    protected void handleExternalTaskIncident(MigratingInstanceParseContext parseContext, IncidentEntity incident) {
        MigratingExternalTaskInstance owningInstance = parseContext.getMigratingExternalTaskInstanceById(incident.getConfiguration());
        if (owningInstance != null) {
            parseContext.consume(incident);
            MigratingIncident migratingIncident = new MigratingIncident(incident, owningInstance.getTargetScope());
            owningInstance.addMigratingDependentInstance(migratingIncident);
        }
    }
}

