/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.migration.validation.instance;

import org.eximeebpms.bpm.engine.impl.jobexecutor.AsyncContinuationJobHandler;
import org.eximeebpms.bpm.engine.impl.migration.instance.MigratingProcessInstance;
import org.eximeebpms.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import org.eximeebpms.bpm.engine.impl.migration.validation.instance.MigratingTransitionInstanceValidationReportImpl;
import org.eximeebpms.bpm.engine.impl.migration.validation.instance.MigratingTransitionInstanceValidator;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.pvm.process.ActivityImpl;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;

public class AsyncProcessStartMigrationValidator
implements MigratingTransitionInstanceValidator {
    @Override
    public void validate(MigratingTransitionInstance migratingInstance, MigratingProcessInstance migratingProcessInstance, MigratingTransitionInstanceValidationReportImpl instanceReport) {
        ActivityImpl targetActivity = (ActivityImpl)migratingInstance.getTargetScope();
        if (targetActivity != null && this.isProcessStartJob(migratingInstance.getJobInstance().getJobEntity()) && !this.isTopLevelActivity(targetActivity)) {
            instanceReport.addFailure("A transition instance that instantiates the process can only be migrated to a process-level flow node");
        }
    }

    protected boolean isProcessStartJob(JobEntity job) {
        AsyncContinuationJobHandler.AsyncContinuationConfiguration configuration = (AsyncContinuationJobHandler.AsyncContinuationConfiguration)job.getJobHandlerConfiguration();
        return PvmAtomicOperation.PROCESS_START.getCanonicalName().equals(configuration.getAtomicOperation());
    }

    protected boolean isTopLevelActivity(ActivityImpl activity) {
        return activity.getFlowScope() == activity.getProcessDefinition();
    }
}

