/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.migration.validation.instruction;

import org.eximeebpms.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.eximeebpms.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidationReportImpl;
import org.eximeebpms.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidator;
import org.eximeebpms.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstruction;
import org.eximeebpms.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructions;
import org.eximeebpms.bpm.engine.impl.pvm.process.ActivityImpl;
import org.eximeebpms.bpm.engine.impl.pvm.process.ScopeImpl;

public class CannotAddMultiInstanceInnerActivityValidator
implements MigrationInstructionValidator {
    @Override
    public void validate(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, MigrationInstructionValidationReportImpl report) {
        ActivityImpl innerActivity;
        ActivityImpl targetActivity = instruction.getTargetActivity();
        if (this.isMultiInstance(targetActivity) && instructions.getInstructionsByTargetScope(innerActivity = this.getInnerActivity(targetActivity)).isEmpty()) {
            report.addFailure("Must map the inner activity of a multi-instance body when the body is mapped");
        }
    }

    protected boolean isMultiInstance(ScopeImpl scope) {
        return scope.getActivityBehavior() instanceof MultiInstanceActivityBehavior;
    }

    protected ActivityImpl getInnerActivity(ActivityImpl multiInstanceBody) {
        MultiInstanceActivityBehavior activityBehavior = (MultiInstanceActivityBehavior)multiInstanceBody.getActivityBehavior();
        return activityBehavior.getInnerActivity(multiInstanceBody);
    }
}

