/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.migration.validation.instruction;

import org.eximeebpms.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.eximeebpms.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.eximeebpms.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidationReportImpl;
import org.eximeebpms.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidator;
import org.eximeebpms.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstruction;
import org.eximeebpms.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructions;
import org.eximeebpms.bpm.engine.impl.pvm.process.ActivityImpl;
import org.eximeebpms.bpm.engine.impl.pvm.process.ScopeImpl;

public class UpdateEventTriggersValidator
implements MigrationInstructionValidator {
    @Override
    public void validate(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, MigrationInstructionValidationReportImpl report) {
        ActivityImpl sourceActivity = instruction.getSourceActivity();
        if (instruction.isUpdateEventTrigger() && !UpdateEventTriggersValidator.definesPersistentEventTrigger(sourceActivity)) {
            report.addFailure("Cannot update event trigger because the activity does not define a persistent event trigger");
        }
    }

    public static boolean definesPersistentEventTrigger(ActivityImpl activity) {
        ScopeImpl eventScope = activity.getEventScope();
        if (eventScope != null) {
            return TimerDeclarationImpl.getDeclarationsForScope(eventScope).containsKey(activity.getId()) || EventSubscriptionDeclaration.getDeclarationsForScope(eventScope).containsKey(activity.getId()) || TimerDeclarationImpl.getTimeoutListenerDeclarationsForScope(eventScope).containsKey(activity.getId());
        }
        return false;
    }
}

