/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.oplog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstance;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.history.event.HistoryEvent;
import org.eximeebpms.bpm.engine.impl.oplog.UserOperationLogContextEntry;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.PropertyChange;
import org.eximeebpms.bpm.engine.impl.persistence.entity.TaskEntity;
import org.eximeebpms.bpm.engine.impl.repository.ResourceDefinitionEntity;

public class UserOperationLogContextEntryBuilder {
    protected UserOperationLogContextEntry entry;

    public static UserOperationLogContextEntryBuilder entry(String operationType, String entityType) {
        UserOperationLogContextEntryBuilder builder = new UserOperationLogContextEntryBuilder();
        builder.entry = new UserOperationLogContextEntry(operationType, entityType);
        return builder;
    }

    public UserOperationLogContextEntryBuilder inContextOf(JobEntity job) {
        this.entry.setJobDefinitionId(job.getJobDefinitionId());
        this.entry.setProcessInstanceId(job.getProcessInstanceId());
        this.entry.setProcessDefinitionId(job.getProcessDefinitionId());
        this.entry.setProcessDefinitionKey(job.getProcessDefinitionKey());
        this.entry.setDeploymentId(job.getDeploymentId());
        this.entry.setTenantId(job.getTenantId());
        ExecutionEntity execution = job.getExecution();
        if (execution != null) {
            this.entry.setRootProcessInstanceId(execution.getRootProcessInstanceId());
        }
        return this;
    }

    public UserOperationLogContextEntryBuilder inContextOf(JobDefinitionEntity jobDefinition) {
        this.entry.setJobDefinitionId(jobDefinition.getId());
        this.entry.setProcessDefinitionId(jobDefinition.getProcessDefinitionId());
        this.entry.setProcessDefinitionKey(jobDefinition.getProcessDefinitionKey());
        this.entry.setTenantId(jobDefinition.getTenantId());
        if (jobDefinition.getProcessDefinitionId() != null) {
            ProcessDefinitionEntity processDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(jobDefinition.getProcessDefinitionId());
            this.entry.setDeploymentId(processDefinition.getDeploymentId());
        }
        return this;
    }

    public UserOperationLogContextEntryBuilder inContextOf(ExecutionEntity execution) {
        this.entry.setProcessInstanceId(execution.getProcessInstanceId());
        this.entry.setRootProcessInstanceId(execution.getRootProcessInstanceId());
        this.entry.setProcessDefinitionId(execution.getProcessDefinitionId());
        this.entry.setTenantId(execution.getTenantId());
        ProcessDefinitionEntity processDefinition = execution.getProcessDefinition();
        this.entry.setProcessDefinitionKey(processDefinition.getKey());
        this.entry.setDeploymentId(processDefinition.getDeploymentId());
        return this;
    }

    public UserOperationLogContextEntryBuilder inContextOf(ProcessDefinitionEntity processDefinition) {
        this.entry.setProcessDefinitionId(processDefinition.getId());
        this.entry.setProcessDefinitionKey(processDefinition.getKey());
        this.entry.setDeploymentId(processDefinition.getDeploymentId());
        this.entry.setTenantId(processDefinition.getTenantId());
        return this;
    }

    public UserOperationLogContextEntryBuilder inContextOf(TaskEntity task, List<PropertyChange> propertyChanges) {
        ExecutionEntity execution;
        if ((propertyChanges == null || propertyChanges.isEmpty()) && "Create".equals(this.entry.getOperationType())) {
            propertyChanges = Arrays.asList(PropertyChange.EMPTY_CHANGE);
        }
        this.entry.setPropertyChanges(propertyChanges);
        ProcessDefinitionEntity definition = task.getProcessDefinition();
        if (definition != null) {
            this.entry.setProcessDefinitionKey(definition.getKey());
            this.entry.setDeploymentId(definition.getDeploymentId());
            this.entry.setTenantId(definition.getTenantId());
        } else if (task.getCaseDefinitionId() != null) {
            this.entry.setDeploymentId(task.getCaseDefinition().getDeploymentId());
            this.entry.setTenantId(task.getCaseDefinition().getTenantId());
        }
        this.entry.setProcessDefinitionId(task.getProcessDefinitionId());
        this.entry.setProcessInstanceId(task.getProcessInstanceId());
        this.entry.setExecutionId(task.getExecutionId());
        this.entry.setCaseDefinitionId(task.getCaseDefinitionId());
        this.entry.setCaseInstanceId(task.getCaseInstanceId());
        this.entry.setCaseExecutionId(task.getCaseExecutionId());
        this.entry.setTaskId(task.getId());
        if (this.entry.getTenantId() == null && task.getTenantId() != null) {
            this.entry.setTenantId(task.getTenantId());
        }
        if ((execution = task.getExecution()) != null) {
            this.entry.setRootProcessInstanceId(execution.getRootProcessInstanceId());
        }
        return this;
    }

    public UserOperationLogContextEntryBuilder inContextOf(HistoricTaskInstance task, List<PropertyChange> propertyChanges) {
        if ((propertyChanges == null || propertyChanges.isEmpty()) && "Create".equals(this.entry.getOperationType())) {
            propertyChanges = Arrays.asList(PropertyChange.EMPTY_CHANGE);
        }
        this.entry.setPropertyChanges(propertyChanges);
        this.entry.setProcessDefinitionKey(task.getProcessDefinitionKey());
        this.entry.setProcessDefinitionId(task.getProcessDefinitionId());
        this.entry.setProcessInstanceId(task.getProcessInstanceId());
        this.entry.setExecutionId(task.getExecutionId());
        this.entry.setCaseDefinitionId(task.getCaseDefinitionId());
        this.entry.setCaseInstanceId(task.getCaseInstanceId());
        this.entry.setCaseExecutionId(task.getCaseExecutionId());
        this.entry.setTaskId(task.getId());
        this.entry.setRootProcessInstanceId(task.getRootProcessInstanceId());
        this.entry.setTenantId(task.getTenantId());
        return this;
    }

    public UserOperationLogContextEntryBuilder inContextOf(ExecutionEntity processInstance, List<PropertyChange> propertyChanges) {
        if ((propertyChanges == null || propertyChanges.isEmpty()) && "Create".equals(this.entry.getOperationType())) {
            propertyChanges = Arrays.asList(PropertyChange.EMPTY_CHANGE);
        }
        this.entry.setPropertyChanges(propertyChanges);
        this.entry.setRootProcessInstanceId(processInstance.getRootProcessInstanceId());
        this.entry.setProcessInstanceId(processInstance.getProcessInstanceId());
        this.entry.setProcessDefinitionId(processInstance.getProcessDefinitionId());
        this.entry.setExecutionId(processInstance.getId());
        this.entry.setCaseInstanceId(processInstance.getCaseInstanceId());
        this.entry.setTenantId(processInstance.getTenantId());
        ProcessDefinitionEntity definition = processInstance.getProcessDefinition();
        if (definition != null) {
            this.entry.setProcessDefinitionKey(definition.getKey());
            this.entry.setDeploymentId(definition.getDeploymentId());
        }
        return this;
    }

    public UserOperationLogContextEntryBuilder inContextOf(HistoryEvent historyEvent, ResourceDefinitionEntity<?> definition, List<PropertyChange> propertyChanges) {
        if ((propertyChanges == null || propertyChanges.isEmpty()) && "Create".equals(this.entry.getOperationType())) {
            propertyChanges = Arrays.asList(PropertyChange.EMPTY_CHANGE);
        }
        this.entry.setPropertyChanges(propertyChanges);
        this.entry.setRootProcessInstanceId(historyEvent.getRootProcessInstanceId());
        this.entry.setProcessDefinitionId(historyEvent.getProcessDefinitionId());
        this.entry.setProcessInstanceId(historyEvent.getProcessInstanceId());
        this.entry.setExecutionId(historyEvent.getExecutionId());
        this.entry.setCaseDefinitionId(historyEvent.getCaseDefinitionId());
        this.entry.setCaseInstanceId(historyEvent.getCaseInstanceId());
        this.entry.setCaseExecutionId(historyEvent.getCaseExecutionId());
        if (definition != null) {
            if (definition instanceof ProcessDefinitionEntity) {
                this.entry.setProcessDefinitionKey(definition.getKey());
            }
            this.entry.setDeploymentId(definition.getDeploymentId());
            this.entry.setTenantId(definition.getTenantId());
        }
        return this;
    }

    public UserOperationLogContextEntryBuilder inContextOf(HistoricVariableInstanceEntity variable, ResourceDefinitionEntity<?> definition, List<PropertyChange> propertyChanges) {
        if ((propertyChanges == null || propertyChanges.isEmpty()) && "Create".equals(this.entry.getOperationType())) {
            propertyChanges = Arrays.asList(PropertyChange.EMPTY_CHANGE);
        }
        this.entry.setPropertyChanges(propertyChanges);
        this.entry.setRootProcessInstanceId(variable.getRootProcessInstanceId());
        this.entry.setProcessDefinitionId(variable.getProcessDefinitionId());
        this.entry.setProcessInstanceId(variable.getProcessInstanceId());
        this.entry.setExecutionId(variable.getExecutionId());
        this.entry.setCaseDefinitionId(variable.getCaseDefinitionId());
        this.entry.setCaseInstanceId(variable.getCaseInstanceId());
        this.entry.setCaseExecutionId(variable.getCaseExecutionId());
        this.entry.setTaskId(variable.getTaskId());
        this.entry.setTenantId(variable.getTenantId());
        if (definition != null) {
            if (definition instanceof ProcessDefinitionEntity) {
                this.entry.setProcessDefinitionKey(definition.getKey());
            }
            this.entry.setDeploymentId(definition.getDeploymentId());
        }
        return this;
    }

    public UserOperationLogContextEntryBuilder inContextOf(ExternalTaskEntity task, ExecutionEntity execution, ProcessDefinitionEntity definition) {
        if (execution != null) {
            this.inContextOf(execution);
        } else if (definition != null) {
            this.inContextOf(definition);
        }
        this.entry.setExternalTaskId(task.getId());
        this.entry.setTenantId(task.getTenantId());
        return this;
    }

    public UserOperationLogContextEntryBuilder propertyChanges(List<PropertyChange> propertyChanges) {
        this.entry.setPropertyChanges(propertyChanges);
        return this;
    }

    public UserOperationLogContextEntryBuilder propertyChanges(PropertyChange propertyChange) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(propertyChange);
        this.entry.setPropertyChanges(propertyChanges);
        return this;
    }

    public UserOperationLogContextEntry create() {
        return this.entry;
    }

    public UserOperationLogContextEntryBuilder jobId(String jobId) {
        this.entry.setJobId(jobId);
        return this;
    }

    public UserOperationLogContextEntryBuilder jobDefinitionId(String jobDefinitionId) {
        this.entry.setJobDefinitionId(jobDefinitionId);
        return this;
    }

    public UserOperationLogContextEntryBuilder processDefinitionId(String processDefinitionId) {
        this.entry.setProcessDefinitionId(processDefinitionId);
        return this;
    }

    public UserOperationLogContextEntryBuilder processDefinitionKey(String processDefinitionKey) {
        this.entry.setProcessDefinitionKey(processDefinitionKey);
        return this;
    }

    public UserOperationLogContextEntryBuilder processInstanceId(String processInstanceId) {
        this.entry.setProcessInstanceId(processInstanceId);
        return this;
    }

    public UserOperationLogContextEntryBuilder caseDefinitionId(String caseDefinitionId) {
        this.entry.setCaseDefinitionId(caseDefinitionId);
        return this;
    }

    public UserOperationLogContextEntryBuilder deploymentId(String deploymentId) {
        this.entry.setDeploymentId(deploymentId);
        return this;
    }

    public UserOperationLogContextEntryBuilder batchId(String batchId) {
        this.entry.setBatchId(batchId);
        return this;
    }

    public UserOperationLogContextEntryBuilder taskId(String taskId) {
        this.entry.setTaskId(taskId);
        return this;
    }

    public UserOperationLogContextEntryBuilder caseInstanceId(String caseInstanceId) {
        this.entry.setCaseInstanceId(caseInstanceId);
        return this;
    }

    public UserOperationLogContextEntryBuilder category(String category) {
        this.entry.setCategory(category);
        return this;
    }

    public UserOperationLogContextEntryBuilder annotation(String annotation) {
        this.entry.setAnnotation(annotation);
        return this;
    }

    public UserOperationLogContextEntryBuilder tenantId(String tenantId) {
        this.entry.setTenantId(tenantId);
        return this;
    }
}

