/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.optimize;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.history.HistoricActivityInstance;
import org.eximeebpms.bpm.engine.history.HistoricDecisionInstance;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstance;
import org.eximeebpms.bpm.engine.history.HistoricTaskInstance;
import org.eximeebpms.bpm.engine.history.HistoricVariableUpdate;
import org.eximeebpms.bpm.engine.history.UserOperationLogEntry;
import org.eximeebpms.bpm.engine.impl.HistoricDecisionInstanceQueryImpl;
import org.eximeebpms.bpm.engine.impl.db.CompositePermissionCheck;
import org.eximeebpms.bpm.engine.impl.db.PermissionCheckBuilder;
import org.eximeebpms.bpm.engine.impl.persistence.AbstractManager;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.optimize.OptimizeHistoricIdentityLinkLogEntity;
import org.eximeebpms.bpm.engine.impl.util.CollectionUtil;

public class OptimizeManager
extends AbstractManager {
    public void fetchHistoricVariableUpdateByteArrays(List<String> byteArrayIds) {
        List<List<String>> partitions = CollectionUtil.partition(byteArrayIds, 2000);
        for (List<String> partition : partitions) {
            this.getDbEntityManager().selectList("selectByteArrays", partition);
        }
    }

    public List<HistoricActivityInstance> getCompletedHistoricActivityInstances(Date finishedAfter, Date finishedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("finishedAfter", finishedAfter);
        params.put("finishedAt", finishedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectCompletedHistoricActivityPage", params);
    }

    public List<HistoricActivityInstance> getRunningHistoricActivityInstances(Date startedAfter, Date startedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("startedAfter", startedAfter);
        params.put("startedAt", startedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectRunningHistoricActivityPage", params);
    }

    public List<HistoricTaskInstance> getCompletedHistoricTaskInstances(Date finishedAfter, Date finishedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("finishedAfter", finishedAfter);
        params.put("finishedAt", finishedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectCompletedHistoricTaskInstancePage", params);
    }

    public List<HistoricTaskInstance> getRunningHistoricTaskInstances(Date startedAfter, Date startedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("startedAfter", startedAfter);
        params.put("startedAt", startedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectRunningHistoricTaskInstancePage", params);
    }

    public List<UserOperationLogEntry> getHistoricUserOperationLogs(Date occurredAfter, Date occurredAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        String[] operationTypes = new String[]{"SuspendJob", "ActivateJob", "SuspendProcessDefinition", "ActivateProcessDefinition", "Suspend", "Activate"};
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("occurredAfter", occurredAfter);
        params.put("occurredAt", occurredAt);
        params.put("operationTypes", operationTypes);
        params.put("maxResults", maxResults);
        return this.getDbEntityManager().selectList("selectHistoricUserOperationLogPage", params);
    }

    public List<OptimizeHistoricIdentityLinkLogEntity> getHistoricIdentityLinkLogs(Date occurredAfter, Date occurredAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("occurredAfter", occurredAfter);
        params.put("occurredAt", occurredAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectHistoricIdentityLinkPage", params);
    }

    public List<HistoricProcessInstance> getCompletedHistoricProcessInstances(Date finishedAfter, Date finishedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("finishedAfter", finishedAfter);
        params.put("finishedAt", finishedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectCompletedHistoricProcessInstancePage", params);
    }

    public List<HistoricProcessInstance> getRunningHistoricProcessInstances(Date startedAfter, Date startedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("startedAfter", startedAfter);
        params.put("startedAt", startedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectRunningHistoricProcessInstancePage", params);
    }

    public List<HistoricVariableUpdate> getHistoricVariableUpdates(Date occurredAfter, Date occurredAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("occurredAfter", occurredAfter);
        params.put("occurredAt", occurredAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectHistoricVariableUpdatePage", params);
    }

    public List<HistoricIncidentEntity> getCompletedHistoricIncidents(Date finishedAfter, Date finishedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("finishedAfter", finishedAfter);
        params.put("finishedAt", finishedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectCompletedHistoricIncidentsPage", params);
    }

    public List<HistoricIncidentEntity> getOpenHistoricIncidents(Date createdAfter, Date createdAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("createdAfter", createdAfter);
        params.put("createdAt", createdAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        return this.getDbEntityManager().selectList("selectOpenHistoricIncidentsPage", params);
    }

    public List<HistoricDecisionInstance> getHistoricDecisionInstances(Date evaluatedAfter, Date evaluatedAt, int maxResults) {
        this.checkIsAuthorizedToReadHistoryAndTenants();
        HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
        params.put("evaluatedAfter", evaluatedAfter);
        params.put("evaluatedAt", evaluatedAt);
        params.put("maxResults", Integer.valueOf(maxResults));
        List decisionInstances = this.getDbEntityManager().selectList("selectHistoricDecisionInstancePage", params);
        HistoricDecisionInstanceQueryImpl query = (HistoricDecisionInstanceQueryImpl)new HistoricDecisionInstanceQueryImpl().disableBinaryFetching().disableCustomObjectDeserialization().includeInputs().includeOutputs();
        List partitions = CollectionUtil.partition(decisionInstances, 2000);
        for (List<HistoricDecisionInstance> list : partitions) {
            this.getHistoricDecisionInstanceManager().enrichHistoricDecisionsWithInputsAndOutputs(query, list);
        }
        return decisionInstances;
    }

    private void checkIsAuthorizedToReadHistoryAndTenants() {
        CompositePermissionCheck necessaryPermissionsForOptimize = new PermissionCheckBuilder().conjunctive().atomicCheckForResourceId(Resources.PROCESS_DEFINITION, "*", Permissions.READ_HISTORY).atomicCheckForResourceId(Resources.DECISION_DEFINITION, "*", Permissions.READ_HISTORY).atomicCheckForResourceId(Resources.TENANT, "*", Permissions.READ).build();
        this.getAuthorizationManager().checkAuthorization(necessaryPermissionsForOptimize);
    }
}

