/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.persistence.deploy.cache;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.cmd.CommandLogger;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.Deployer;
import org.eximeebpms.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ResourceEntity;

public class CacheDeployer {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected List<Deployer> deployers = Collections.emptyList();

    public void setDeployers(List<Deployer> deployers) {
        this.deployers = deployers;
    }

    public void deploy(final DeploymentEntity deployment) {
        Context.getCommandContext().runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (Deployer deployer : CacheDeployer.this.deployers) {
                    deployer.deploy(deployment);
                }
                return null;
            }
        });
    }

    public void deployOnlyGivenResourcesOfDeployment(final DeploymentEntity deployment, String ... resourceNames) {
        this.initDeployment(deployment, resourceNames);
        Context.getCommandContext().runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (Deployer deployer : CacheDeployer.this.deployers) {
                    deployer.deploy(deployment);
                }
                return null;
            }
        });
        deployment.setResources(null);
    }

    protected void initDeployment(DeploymentEntity deployment, String ... resourceNames) {
        deployment.clearResources();
        for (String resourceName : resourceNames) {
            if (resourceName == null) continue;
            ResourceEntity resource = Context.getCommandContext().getResourceManager().findResourceByDeploymentIdAndResourceName(deployment.getId(), resourceName);
            deployment.addResource(resource);
        }
    }
}

