/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.persistence.deploy.cache;

import org.eximeebpms.bpm.engine.exception.cmmn.CaseDefinitionNotFoundException;
import org.eximeebpms.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.persistence.AbstractResourceDefinitionManager;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.CacheDeployer;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.CacheFactory;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.ResourceDefinitionCache;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class CaseDefinitionCache
extends ResourceDefinitionCache<CaseDefinitionEntity> {
    public CaseDefinitionCache(CacheFactory factory, int cacheCapacity, CacheDeployer cacheDeployer) {
        super(factory, cacheCapacity, cacheDeployer);
    }

    public CaseDefinitionEntity getCaseDefinitionById(String caseDefinitionId) {
        this.checkInvalidDefinitionId(caseDefinitionId);
        CaseDefinitionEntity caseDefinition = (CaseDefinitionEntity)this.getDefinition(caseDefinitionId);
        if (caseDefinition == null) {
            caseDefinition = (CaseDefinitionEntity)this.findDeployedDefinitionById(caseDefinitionId);
        }
        return caseDefinition;
    }

    @Override
    protected AbstractResourceDefinitionManager<CaseDefinitionEntity> getManager() {
        return Context.getCommandContext().getCaseDefinitionManager();
    }

    @Override
    protected void checkInvalidDefinitionId(String definitionId) {
        EnsureUtil.ensureNotNull("Invalid case definition id", "caseDefinitionId", (Object)definitionId);
    }

    @Override
    protected void checkDefinitionFound(String definitionId, CaseDefinitionEntity definition) {
        EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "no deployed case definition found with id '" + definitionId + "'", "caseDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKey(String definitionKey, CaseDefinitionEntity definition) {
        EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "no case definition deployed with key '" + definitionKey + "'", "caseDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyAndTenantId(String definitionKey, String tenantId, CaseDefinitionEntity definition) {
        EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "no case definition deployed with key '" + definitionKey + "' and tenant-id '" + tenantId + "'", "caseDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyVersionAndTenantId(String definitionKey, Integer definitionVersion, String tenantId, CaseDefinitionEntity definition) {
        EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "no case definition deployed with key = '" + definitionKey + "', version = '" + definitionVersion + "' and tenant-id = '" + tenantId + "'", "caseDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyVersionTagAndTenantId(String definitionKey, String definitionVersionTag, String tenantId, CaseDefinitionEntity definition) {
        throw new UnsupportedOperationException("Version tag is not implemented in case definition.");
    }

    @Override
    protected void checkInvalidDefinitionByDeploymentAndKey(String deploymentId, String definitionKey, CaseDefinitionEntity definition) {
        EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "no case definition deployed with key = '" + definitionKey + "' in deployment = '" + deploymentId + "'", "caseDefinition", (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionWasCached(String deploymentId, String definitionId, CaseDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("deployment '" + deploymentId + "' didn't put case definition '" + definitionId + "' in the cache", "cachedCaseDefinition", (Object)definition);
    }
}

