/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.persistence.deploy.cache;

import java.util.List;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionQueryImpl;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.Deployer;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.BpmnModelInstanceCache;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.CacheDeployer;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.CacheFactory;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.CachePurgeReport;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.CamundaFormDefinitionCache;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.CaseDefinitionCache;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.CmmnModelInstanceCache;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.DecisionDefinitionCache;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.DecisionRequirementsDefinitionCache;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.DmnModelInstanceCache;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.ProcessDefinitionCache;
import org.eximeebpms.bpm.engine.impl.persistence.entity.CamundaFormDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.eximeebpms.bpm.engine.repository.DecisionDefinition;
import org.eximeebpms.bpm.engine.repository.DecisionRequirementsDefinition;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.cmmn.CmmnModelInstance;
import org.eximeebpms.bpm.model.dmn.DmnModelInstance;
import org.eximeebpms.commons.utils.cache.Cache;

public class DeploymentCache {
    protected ProcessDefinitionCache processDefinitionEntityCache;
    protected CaseDefinitionCache caseDefinitionCache;
    protected DecisionDefinitionCache decisionDefinitionCache;
    protected DecisionRequirementsDefinitionCache decisionRequirementsDefinitionCache;
    protected CamundaFormDefinitionCache camundaFormDefinitionCache;
    protected BpmnModelInstanceCache bpmnModelInstanceCache;
    protected CmmnModelInstanceCache cmmnModelInstanceCache;
    protected DmnModelInstanceCache dmnModelInstanceCache;
    protected CacheDeployer cacheDeployer = new CacheDeployer();

    public DeploymentCache(CacheFactory factory, int cacheCapacity) {
        this.processDefinitionEntityCache = new ProcessDefinitionCache(factory, cacheCapacity, this.cacheDeployer);
        this.caseDefinitionCache = new CaseDefinitionCache(factory, cacheCapacity, this.cacheDeployer);
        this.decisionDefinitionCache = new DecisionDefinitionCache(factory, cacheCapacity, this.cacheDeployer);
        this.decisionRequirementsDefinitionCache = new DecisionRequirementsDefinitionCache(factory, cacheCapacity, this.cacheDeployer);
        this.camundaFormDefinitionCache = new CamundaFormDefinitionCache(factory, cacheCapacity, this.cacheDeployer);
        this.bpmnModelInstanceCache = new BpmnModelInstanceCache(factory, cacheCapacity, this.processDefinitionEntityCache);
        this.cmmnModelInstanceCache = new CmmnModelInstanceCache(factory, cacheCapacity, this.caseDefinitionCache);
        this.dmnModelInstanceCache = new DmnModelInstanceCache(factory, cacheCapacity, this.decisionDefinitionCache);
    }

    public void deploy(DeploymentEntity deployment) {
        this.cacheDeployer.deploy(deployment);
    }

    public ProcessDefinitionEntity findProcessDefinitionFromCache(String processDefinitionId) {
        return (ProcessDefinitionEntity)this.processDefinitionEntityCache.findDefinitionFromCache(processDefinitionId);
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionById(String processDefinitionId) {
        return (ProcessDefinitionEntity)this.processDefinitionEntityCache.findDeployedDefinitionById(processDefinitionId);
    }

    public ProcessDefinitionEntity findDeployedLatestProcessDefinitionByKey(String processDefinitionKey) {
        return (ProcessDefinitionEntity)this.processDefinitionEntityCache.findDeployedLatestDefinitionByKey(processDefinitionKey);
    }

    public ProcessDefinitionEntity findDeployedLatestProcessDefinitionByKeyAndTenantId(String processDefinitionKey, String tenantId) {
        return (ProcessDefinitionEntity)this.processDefinitionEntityCache.findDeployedLatestDefinitionByKeyAndTenantId(processDefinitionKey, tenantId);
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionByKeyVersionAndTenantId(String processDefinitionKey, Integer processDefinitionVersion, String tenantId) {
        return (ProcessDefinitionEntity)this.processDefinitionEntityCache.findDeployedDefinitionByKeyVersionAndTenantId(processDefinitionKey, processDefinitionVersion, tenantId);
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionByKeyVersionTagAndTenantId(String processDefinitionKey, String processDefinitionVersionTag, String tenantId) {
        return (ProcessDefinitionEntity)this.processDefinitionEntityCache.findDeployedDefinitionByKeyVersionTagAndTenantId(processDefinitionKey, processDefinitionVersionTag, tenantId);
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionByDeploymentAndKey(String deploymentId, String processDefinitionKey) {
        return (ProcessDefinitionEntity)this.processDefinitionEntityCache.findDeployedDefinitionByDeploymentAndKey(deploymentId, processDefinitionKey);
    }

    public ProcessDefinitionEntity resolveProcessDefinition(ProcessDefinitionEntity processDefinition) {
        return this.processDefinitionEntityCache.resolveDefinition(processDefinition);
    }

    public BpmnModelInstance findBpmnModelInstanceForProcessDefinition(ProcessDefinitionEntity processDefinitionEntity) {
        return (BpmnModelInstance)this.bpmnModelInstanceCache.findBpmnModelInstanceForDefinition(processDefinitionEntity);
    }

    public BpmnModelInstance findBpmnModelInstanceForProcessDefinition(String processDefinitionId) {
        return (BpmnModelInstance)this.bpmnModelInstanceCache.findBpmnModelInstanceForDefinition(processDefinitionId);
    }

    public void addProcessDefinition(ProcessDefinitionEntity processDefinition) {
        this.processDefinitionEntityCache.addDefinition(processDefinition);
    }

    public void removeProcessDefinition(String processDefinitionId) {
        this.processDefinitionEntityCache.removeDefinitionFromCache(processDefinitionId);
        this.bpmnModelInstanceCache.remove(processDefinitionId);
    }

    public void discardProcessDefinitionCache() {
        this.processDefinitionEntityCache.clear();
        this.bpmnModelInstanceCache.clear();
    }

    public void addCamundaFormDefinition(CamundaFormDefinitionEntity camundaFormDefinition) {
        this.camundaFormDefinitionCache.addDefinition(camundaFormDefinition);
    }

    public void removeCamundaFormDefinition(String camundaFormDefinitionId) {
        this.camundaFormDefinitionCache.removeDefinitionFromCache(camundaFormDefinitionId);
    }

    public void discardCamundaFormDefinitionCache() {
        this.camundaFormDefinitionCache.clear();
    }

    public CaseDefinitionEntity findCaseDefinitionFromCache(String caseDefinitionId) {
        return (CaseDefinitionEntity)this.caseDefinitionCache.findDefinitionFromCache(caseDefinitionId);
    }

    public CaseDefinitionEntity findDeployedCaseDefinitionById(String caseDefinitionId) {
        return (CaseDefinitionEntity)this.caseDefinitionCache.findDeployedDefinitionById(caseDefinitionId);
    }

    public CaseDefinitionEntity findDeployedLatestCaseDefinitionByKey(String caseDefinitionKey) {
        return (CaseDefinitionEntity)this.caseDefinitionCache.findDeployedLatestDefinitionByKey(caseDefinitionKey);
    }

    public CaseDefinitionEntity findDeployedLatestCaseDefinitionByKeyAndTenantId(String caseDefinitionKey, String tenantId) {
        return (CaseDefinitionEntity)this.caseDefinitionCache.findDeployedLatestDefinitionByKeyAndTenantId(caseDefinitionKey, tenantId);
    }

    public CaseDefinitionEntity findDeployedCaseDefinitionByKeyVersionAndTenantId(String caseDefinitionKey, Integer caseDefinitionVersion, String tenantId) {
        return (CaseDefinitionEntity)this.caseDefinitionCache.findDeployedDefinitionByKeyVersionAndTenantId(caseDefinitionKey, caseDefinitionVersion, tenantId);
    }

    public CaseDefinitionEntity findDeployedCaseDefinitionByDeploymentAndKey(String deploymentId, String caseDefinitionKey) {
        return (CaseDefinitionEntity)this.caseDefinitionCache.findDeployedDefinitionByDeploymentAndKey(deploymentId, caseDefinitionKey);
    }

    public CaseDefinitionEntity getCaseDefinitionById(String caseDefinitionId) {
        return this.caseDefinitionCache.getCaseDefinitionById(caseDefinitionId);
    }

    public CaseDefinitionEntity resolveCaseDefinition(CaseDefinitionEntity caseDefinition) {
        return this.caseDefinitionCache.resolveDefinition(caseDefinition);
    }

    public CmmnModelInstance findCmmnModelInstanceForCaseDefinition(String caseDefinitionId) {
        return (CmmnModelInstance)this.cmmnModelInstanceCache.findBpmnModelInstanceForDefinition(caseDefinitionId);
    }

    public void addCaseDefinition(CaseDefinitionEntity caseDefinition) {
        this.caseDefinitionCache.addDefinition(caseDefinition);
    }

    public void removeCaseDefinition(String caseDefinitionId) {
        this.caseDefinitionCache.removeDefinitionFromCache(caseDefinitionId);
        this.cmmnModelInstanceCache.remove(caseDefinitionId);
    }

    public void discardCaseDefinitionCache() {
        this.caseDefinitionCache.clear();
        this.cmmnModelInstanceCache.clear();
    }

    public DecisionDefinitionEntity findDecisionDefinitionFromCache(String decisionDefinitionId) {
        return (DecisionDefinitionEntity)this.decisionDefinitionCache.findDefinitionFromCache(decisionDefinitionId);
    }

    public DecisionDefinitionEntity findDeployedDecisionDefinitionById(String decisionDefinitionId) {
        return (DecisionDefinitionEntity)this.decisionDefinitionCache.findDeployedDefinitionById(decisionDefinitionId);
    }

    public DecisionDefinition findDeployedLatestDecisionDefinitionByKey(String decisionDefinitionKey) {
        return (DecisionDefinition)this.decisionDefinitionCache.findDeployedLatestDefinitionByKey(decisionDefinitionKey);
    }

    public DecisionDefinition findDeployedLatestDecisionDefinitionByKeyAndTenantId(String decisionDefinitionKey, String tenantId) {
        return (DecisionDefinition)this.decisionDefinitionCache.findDeployedLatestDefinitionByKeyAndTenantId(decisionDefinitionKey, tenantId);
    }

    public DecisionDefinition findDeployedDecisionDefinitionByDeploymentAndKey(String deploymentId, String decisionDefinitionKey) {
        return (DecisionDefinition)this.decisionDefinitionCache.findDeployedDefinitionByDeploymentAndKey(deploymentId, decisionDefinitionKey);
    }

    public DecisionDefinition findDeployedDecisionDefinitionByKeyAndVersion(String decisionDefinitionKey, Integer decisionDefinitionVersion) {
        return this.decisionDefinitionCache.findDeployedDefinitionByKeyAndVersion(decisionDefinitionKey, decisionDefinitionVersion);
    }

    public DecisionDefinition findDeployedDecisionDefinitionByKeyVersionAndTenantId(String decisionDefinitionKey, Integer decisionDefinitionVersion, String tenantId) {
        return (DecisionDefinition)this.decisionDefinitionCache.findDeployedDefinitionByKeyVersionAndTenantId(decisionDefinitionKey, decisionDefinitionVersion, tenantId);
    }

    public DecisionDefinition findDeployedDecisionDefinitionByKeyVersionTagAndTenantId(String decisionDefinitionKey, String decisionDefinitionVersionTag, String tenantId) {
        return (DecisionDefinition)this.decisionDefinitionCache.findDeployedDefinitionByKeyVersionTagAndTenantId(decisionDefinitionKey, decisionDefinitionVersionTag, tenantId);
    }

    public DecisionDefinitionEntity resolveDecisionDefinition(DecisionDefinitionEntity decisionDefinition) {
        return this.decisionDefinitionCache.resolveDefinition(decisionDefinition);
    }

    public DmnModelInstance findDmnModelInstanceForDecisionDefinition(String decisionDefinitionId) {
        return (DmnModelInstance)this.dmnModelInstanceCache.findBpmnModelInstanceForDefinition(decisionDefinitionId);
    }

    public void addDecisionDefinition(DecisionDefinitionEntity decisionDefinition) {
        this.decisionDefinitionCache.addDefinition(decisionDefinition);
    }

    public void removeDecisionDefinition(String decisionDefinitionId) {
        this.decisionDefinitionCache.removeDefinitionFromCache(decisionDefinitionId);
        this.dmnModelInstanceCache.remove(decisionDefinitionId);
    }

    public void discardDecisionDefinitionCache() {
        this.decisionDefinitionCache.clear();
        this.dmnModelInstanceCache.clear();
    }

    public void addDecisionRequirementsDefinition(DecisionRequirementsDefinitionEntity decisionRequirementsDefinition) {
        this.decisionRequirementsDefinitionCache.addDefinition(decisionRequirementsDefinition);
    }

    public DecisionRequirementsDefinitionEntity findDecisionRequirementsDefinitionFromCache(String decisionRequirementsDefinitionId) {
        return (DecisionRequirementsDefinitionEntity)this.decisionRequirementsDefinitionCache.findDefinitionFromCache(decisionRequirementsDefinitionId);
    }

    public DecisionRequirementsDefinitionEntity findDeployedDecisionRequirementsDefinitionById(String decisionRequirementsDefinitionId) {
        return (DecisionRequirementsDefinitionEntity)this.decisionRequirementsDefinitionCache.findDeployedDefinitionById(decisionRequirementsDefinitionId);
    }

    public DecisionRequirementsDefinitionEntity resolveDecisionRequirementsDefinition(DecisionRequirementsDefinitionEntity decisionRequirementsDefinition) {
        return this.decisionRequirementsDefinitionCache.resolveDefinition(decisionRequirementsDefinition);
    }

    public void discardDecisionRequirementsDefinitionCache() {
        this.decisionDefinitionCache.clear();
    }

    public void removeDecisionRequirementsDefinition(String decisionRequirementsDefinitionId) {
        this.decisionRequirementsDefinitionCache.removeDefinitionFromCache(decisionRequirementsDefinitionId);
    }

    public Cache<String, BpmnModelInstance> getBpmnModelInstanceCache() {
        return this.bpmnModelInstanceCache.getCache();
    }

    public Cache<String, CmmnModelInstance> getCmmnModelInstanceCache() {
        return this.cmmnModelInstanceCache.getCache();
    }

    public Cache<String, DmnModelInstance> getDmnDefinitionCache() {
        return this.dmnModelInstanceCache.getCache();
    }

    public Cache<String, DecisionDefinitionEntity> getDecisionDefinitionCache() {
        return this.decisionDefinitionCache.getCache();
    }

    public Cache<String, DecisionRequirementsDefinitionEntity> getDecisionRequirementsDefinitionCache() {
        return this.decisionRequirementsDefinitionCache.getCache();
    }

    public Cache<String, ProcessDefinitionEntity> getProcessDefinitionCache() {
        return this.processDefinitionEntityCache.getCache();
    }

    public Cache<String, CaseDefinitionEntity> getCaseDefinitionCache() {
        return this.caseDefinitionCache.getCache();
    }

    public void setDeployers(List<Deployer> deployers) {
        this.cacheDeployer.setDeployers(deployers);
    }

    public void removeDeployment(String deploymentId) {
        this.bpmnModelInstanceCache.removeAllDefinitionsByDeploymentId(deploymentId);
        if (Context.getProcessEngineConfiguration().isCmmnEnabled()) {
            this.cmmnModelInstanceCache.removeAllDefinitionsByDeploymentId(deploymentId);
        }
        if (Context.getProcessEngineConfiguration().isDmnEnabled()) {
            this.dmnModelInstanceCache.removeAllDefinitionsByDeploymentId(deploymentId);
            this.removeAllDecisionRequirementsDefinitionsByDeploymentId(deploymentId);
        }
    }

    protected void removeAllDecisionRequirementsDefinitionsByDeploymentId(String deploymentId) {
        List allDefinitionsForDeployment = new DecisionRequirementsDefinitionQueryImpl().deploymentId(deploymentId).list();
        for (DecisionRequirementsDefinition decisionRequirementsDefinition : allDefinitionsForDeployment) {
            try {
                this.removeDecisionDefinition(decisionRequirementsDefinition.getId());
            }
            catch (Exception e) {
                ProcessEngineLogger.PERSISTENCE_LOGGER.removeEntryFromDeploymentCacheFailure("decision requirement", decisionRequirementsDefinition.getId(), e);
            }
        }
    }

    public CachePurgeReport purgeCache() {
        Cache<String, DecisionRequirementsDefinitionEntity> decisionRequirementsDefinitionCache;
        Cache<String, DmnModelInstance> dmnModelInstanceCache;
        Cache<String, DecisionDefinitionEntity> decisionDefinitionCache;
        Cache<String, CmmnModelInstance> cmmnModelInstanceCache;
        Cache<String, CaseDefinitionEntity> caseDefinitionCache;
        Cache<String, BpmnModelInstance> bpmnModelInstanceCache;
        CachePurgeReport result = new CachePurgeReport();
        Cache<String, ProcessDefinitionEntity> processDefinitionCache = this.getProcessDefinitionCache();
        if (!processDefinitionCache.isEmpty()) {
            result.addPurgeInformation("PROC_DEF_CACHE", processDefinitionCache.keySet());
            processDefinitionCache.clear();
        }
        if (!(bpmnModelInstanceCache = this.getBpmnModelInstanceCache()).isEmpty()) {
            result.addPurgeInformation("BPMN_MODEL_INST_CACHE", bpmnModelInstanceCache.keySet());
            bpmnModelInstanceCache.clear();
        }
        if (!(caseDefinitionCache = this.getCaseDefinitionCache()).isEmpty()) {
            result.addPurgeInformation("CASE_DEF_CACHE", caseDefinitionCache.keySet());
            caseDefinitionCache.clear();
        }
        if (!(cmmnModelInstanceCache = this.getCmmnModelInstanceCache()).isEmpty()) {
            result.addPurgeInformation("CASE_MODEL_INST_CACHE", cmmnModelInstanceCache.keySet());
            cmmnModelInstanceCache.clear();
        }
        if (!(decisionDefinitionCache = this.getDecisionDefinitionCache()).isEmpty()) {
            result.addPurgeInformation("DMN_DEF_CACHE", decisionDefinitionCache.keySet());
            decisionDefinitionCache.clear();
        }
        if (!(dmnModelInstanceCache = this.getDmnDefinitionCache()).isEmpty()) {
            result.addPurgeInformation("DMN_MODEL_INST_CACHE", dmnModelInstanceCache.keySet());
            dmnModelInstanceCache.clear();
        }
        if (!(decisionRequirementsDefinitionCache = this.getDecisionRequirementsDefinitionCache()).isEmpty()) {
            result.addPurgeInformation("DMN_REQ_DEF_CACHE", decisionRequirementsDefinitionCache.keySet());
            decisionRequirementsDefinitionCache.clear();
        }
        return result;
    }
}

