/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import org.eximeebpms.bpm.engine.batch.Batch;
import org.eximeebpms.bpm.engine.impl.Page;
import org.eximeebpms.bpm.engine.impl.batch.BatchEntity;
import org.eximeebpms.bpm.engine.impl.batch.BatchQueryImpl;
import org.eximeebpms.bpm.engine.impl.db.ListQueryParameterObject;
import org.eximeebpms.bpm.engine.impl.persistence.AbstractManager;
import org.eximeebpms.bpm.engine.impl.persistence.entity.SuspensionState;

public class BatchManager
extends AbstractManager {
    public void insertBatch(BatchEntity batch) {
        batch.setCreateUserId(this.getCommandContext().getAuthenticatedUserId());
        this.getDbEntityManager().insert(batch);
    }

    public BatchEntity findBatchById(String id) {
        return this.getDbEntityManager().selectById(BatchEntity.class, id);
    }

    public long findBatchCountByQueryCriteria(BatchQueryImpl batchQuery) {
        this.configureQuery(batchQuery);
        return (Long)this.getDbEntityManager().selectOne("selectBatchCountByQueryCriteria", batchQuery);
    }

    public List<Batch> findBatchesByQueryCriteria(BatchQueryImpl batchQuery, Page page) {
        this.configureQuery(batchQuery);
        return this.getDbEntityManager().selectList("selectBatchesByQueryCriteria", batchQuery, page);
    }

    public void updateBatchSuspensionStateById(String batchId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("batchId", batchId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        ListQueryParameterObject queryParameter = new ListQueryParameterObject();
        queryParameter.setParameter(parameters);
        this.getDbEntityManager().update(BatchEntity.class, "updateBatchSuspensionStateByParameters", queryParameter);
    }

    protected void configureQuery(BatchQueryImpl batchQuery) {
        this.getAuthorizationManager().configureBatchQuery(batchQuery);
        this.getTenantManager().configureQuery(batchQuery);
    }
}

