/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.persistence.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eximeebpms.bpm.engine.history.HistoricIncident;
import org.eximeebpms.bpm.engine.impl.HistoricIncidentQueryImpl;
import org.eximeebpms.bpm.engine.impl.Page;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.db.ListQueryParameterObject;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.eximeebpms.bpm.engine.impl.history.HistoryLevel;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricIncidentEventEntity;
import org.eximeebpms.bpm.engine.impl.history.event.HistoryEventTypes;
import org.eximeebpms.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;

public class HistoricIncidentManager
extends AbstractHistoricManager {
    public long findHistoricIncidentCountByQueryCriteria(HistoricIncidentQueryImpl query) {
        this.configureQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectHistoricIncidentCountByQueryCriteria", query);
    }

    public HistoricIncidentEntity findHistoricIncidentById(String id) {
        return (HistoricIncidentEntity)this.getDbEntityManager().selectOne("selectHistoricIncidentById", id);
    }

    public List<HistoricIncident> findHistoricIncidentByQueryCriteria(HistoricIncidentQueryImpl query, Page page) {
        this.configureQuery(query);
        return this.getDbEntityManager().selectList("selectHistoricIncidentByQueryCriteria", query, page);
    }

    public DbOperation addRemovalTimeToIncidentsByRootProcessInstanceId(String rootProcessInstanceId, Date removalTime, Integer batchSize) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rootProcessInstanceId", rootProcessInstanceId);
        parameters.put("removalTime", removalTime);
        parameters.put("maxResults", batchSize);
        return this.getDbEntityManager().updatePreserveOrder(HistoricIncidentEventEntity.class, "updateHistoricIncidentsByRootProcessInstanceId", parameters);
    }

    public DbOperation addRemovalTimeToIncidentsByProcessInstanceId(String processInstanceId, Date removalTime, Integer batchSize) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("removalTime", removalTime);
        parameters.put("maxResults", batchSize);
        return this.getDbEntityManager().updatePreserveOrder(HistoricIncidentEventEntity.class, "updateHistoricIncidentsByProcessInstanceId", parameters);
    }

    public void deleteHistoricIncidentsByProcessInstanceIds(List<String> processInstanceIds) {
        this.getDbEntityManager().deletePreserveOrder(HistoricIncidentEntity.class, "deleteHistoricIncidentsByProcessInstanceIds", processInstanceIds);
    }

    public void deleteHistoricIncidentsByProcessDefinitionId(String processDefinitionId) {
        if (this.isHistoryEventProduced()) {
            this.getDbEntityManager().delete(HistoricIncidentEntity.class, "deleteHistoricIncidentsByProcessDefinitionId", processDefinitionId);
        }
    }

    public void deleteHistoricIncidentsByJobDefinitionId(String jobDefinitionId) {
        if (this.isHistoryEventProduced()) {
            this.getDbEntityManager().delete(HistoricIncidentEntity.class, "deleteHistoricIncidentsByJobDefinitionId", jobDefinitionId);
        }
    }

    public void deleteHistoricIncidentsByBatchId(List<String> historicBatchIds) {
        if (this.isHistoryEventProduced()) {
            this.getDbEntityManager().delete(HistoricIncidentEntity.class, "deleteHistoricIncidentsByBatchIds", historicBatchIds);
        }
    }

    protected void configureQuery(HistoricIncidentQueryImpl query) {
        this.getAuthorizationManager().configureHistoricIncidentQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    protected boolean isHistoryEventProduced() {
        HistoryLevel historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        return historyLevel.isHistoryEventProduced(HistoryEventTypes.INCIDENT_CREATE, null) || historyLevel.isHistoryEventProduced(HistoryEventTypes.INCIDENT_DELETE, null) || historyLevel.isHistoryEventProduced(HistoryEventTypes.INCIDENT_MIGRATE, null) || historyLevel.isHistoryEventProduced(HistoryEventTypes.INCIDENT_RESOLVE, null);
    }

    public DbOperation deleteHistoricIncidentsByRemovalTime(Date removalTime, int minuteFrom, int minuteTo, int batchSize) {
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("removalTime", removalTime);
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        parameters.put("batchSize", Integer.valueOf(batchSize));
        return this.getDbEntityManager().deletePreserveOrder(HistoricIncidentEntity.class, "deleteHistoricIncidentsByRemovalTime", new ListQueryParameterObject(parameters, 0, batchSize));
    }

    public void addRemovalTimeToHistoricIncidentsByBatchId(String batchId, Date removalTime) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("batchId", batchId);
        parameters.put("removalTime", removalTime);
        this.getDbEntityManager().updatePreserveOrder(HistoricIncidentEntity.class, "updateHistoricIncidentsByBatchId", parameters);
    }
}

