/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.history.CleanableHistoricProcessInstanceReportResult;
import org.eximeebpms.bpm.engine.history.HistoricProcessInstance;
import org.eximeebpms.bpm.engine.impl.CleanableHistoricProcessInstanceReportImpl;
import org.eximeebpms.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.eximeebpms.bpm.engine.impl.Page;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.db.DbEntity;
import org.eximeebpms.bpm.engine.impl.db.ListQueryParameterObject;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.operation.DbBulkOperation;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricActivityInstanceEventEntity;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricDetailEventEntity;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricExternalTaskLogEntity;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricIdentityLinkLogEventEntity;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricIncidentEventEntity;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.eximeebpms.bpm.engine.impl.history.event.HistoricTaskInstanceEventEntity;
import org.eximeebpms.bpm.engine.impl.history.event.UserOperationLogEntryEventEntity;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.eximeebpms.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.CommentEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.impl.util.CollectionUtil;
import org.eximeebpms.bpm.engine.impl.util.ImmutablePair;

public class HistoricProcessInstanceManager
extends AbstractHistoricManager {
    public HistoricProcessInstanceEntity findHistoricProcessInstance(String processInstanceId) {
        if (this.isHistoryEnabled()) {
            return this.getDbEntityManager().selectById(HistoricProcessInstanceEntity.class, processInstanceId);
        }
        return null;
    }

    public HistoricProcessInstanceEventEntity findHistoricProcessInstanceEvent(String eventId) {
        if (this.isHistoryEnabled()) {
            return this.getDbEntityManager().selectById(HistoricProcessInstanceEventEntity.class, eventId);
        }
        return null;
    }

    public void deleteHistoricProcessInstanceByProcessDefinitionId(String processDefinitionId) {
        List historicProcessInstanceIds;
        if (this.isHistoryEnabled() && !(historicProcessInstanceIds = this.getDbEntityManager().selectList("selectHistoricProcessInstanceIdsByProcessDefinitionId", processDefinitionId)).isEmpty()) {
            this.deleteHistoricProcessInstanceByIds(historicProcessInstanceIds);
        }
    }

    public void deleteHistoricProcessInstanceByIds(List<String> processInstanceIds) {
        if (this.isHistoryEnabled()) {
            CommandContext commandContext = this.getCommandContext();
            List<List<String>> partitions = CollectionUtil.partition(processInstanceIds, 2000);
            for (List<String> partition : partitions) {
                commandContext.getHistoricDetailManager().deleteHistoricDetailsByProcessInstanceIds(partition);
                commandContext.getHistoricVariableInstanceManager().deleteHistoricVariableInstanceByProcessInstanceIds(partition);
                commandContext.getCommentManager().deleteCommentsByProcessInstanceIds(partition);
                commandContext.getAttachmentManager().deleteAttachmentsByProcessInstanceIds(partition);
                commandContext.getHistoricTaskInstanceManager().deleteHistoricTaskInstancesByProcessInstanceIds(partition, false);
                commandContext.getHistoricActivityInstanceManager().deleteHistoricActivityInstancesByProcessInstanceIds(partition);
                commandContext.getHistoricIncidentManager().deleteHistoricIncidentsByProcessInstanceIds(partition);
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByProcessInstanceIds(partition);
                commandContext.getHistoricExternalTaskLogManager().deleteHistoricExternalTaskLogsByProcessInstanceIds(partition);
                commandContext.getAuthorizationManager().deleteAuthorizationsByResourceIds(Resources.HISTORIC_PROCESS_INSTANCE, partition);
                commandContext.getDbEntityManager().deletePreserveOrder(HistoricProcessInstanceEntity.class, "deleteHistoricProcessInstances", partition);
            }
        }
    }

    public long findHistoricProcessInstanceCountByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        if (this.isHistoryEnabled()) {
            this.configureQuery(historicProcessInstanceQuery);
            return (Long)this.getDbEntityManager().selectOne("selectHistoricProcessInstanceCountByQueryCriteria", historicProcessInstanceQuery);
        }
        return 0L;
    }

    public List<HistoricProcessInstance> findHistoricProcessInstancesByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery, Page page) {
        if (this.isHistoryEnabled()) {
            this.configureQuery(historicProcessInstanceQuery);
            return this.getDbEntityManager().selectList("selectHistoricProcessInstancesByQueryCriteria", historicProcessInstanceQuery, page);
        }
        return Collections.EMPTY_LIST;
    }

    public List<HistoricProcessInstance> findHistoricProcessInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbEntityManager().selectListWithRawParameter("selectHistoricProcessInstanceByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findHistoricProcessInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbEntityManager().selectOne("selectHistoricProcessInstanceCountByNativeQuery", parameterMap);
    }

    public List<String> findHistoricProcessInstanceIdsForCleanup(Integer batchSize, int minuteFrom, int minuteTo) {
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("currentTimestamp", ClockUtil.getCurrentTime());
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        ListQueryParameterObject parameterObject = new ListQueryParameterObject(parameters, 0, batchSize);
        return this.getDbEntityManager().selectList("selectHistoricProcessInstanceIdsForCleanup", parameterObject);
    }

    public List<String> findHistoricProcessInstanceIds(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        this.configureQuery(historicProcessInstanceQuery);
        return this.getDbEntityManager().selectList("selectHistoricProcessInstanceIdsByQueryCriteria", historicProcessInstanceQuery);
    }

    public List<ImmutablePair<String, String>> findDeploymentIdMappingsByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        this.configureQuery(historicProcessInstanceQuery);
        return this.getDbEntityManager().selectList("selectHistoricProcessInstanceDeploymentIdMappingsByQueryCriteria", historicProcessInstanceQuery);
    }

    public List<CleanableHistoricProcessInstanceReportResult> findCleanableHistoricProcessInstancesReportByCriteria(CleanableHistoricProcessInstanceReportImpl query, Page page) {
        query.setCurrentTimestamp(ClockUtil.getCurrentTime());
        this.getAuthorizationManager().configureQueryHistoricFinishedInstanceReport(query, Resources.PROCESS_DEFINITION);
        this.getTenantManager().configureQuery(query);
        return this.getDbEntityManager().selectList("selectFinishedProcessInstancesReportEntities", query, page);
    }

    public long findCleanableHistoricProcessInstancesReportCountByCriteria(CleanableHistoricProcessInstanceReportImpl query) {
        query.setCurrentTimestamp(ClockUtil.getCurrentTime());
        this.getAuthorizationManager().configureQueryHistoricFinishedInstanceReport(query, Resources.PROCESS_DEFINITION);
        this.getTenantManager().configureQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectFinishedProcessInstancesReportEntitiesCount", query);
    }

    public void addRemovalTimeToProcessInstancesByRootProcessInstanceId(String rootProcessInstanceId, Date removalTime) {
        this.addRemovalTimeToProcessInstancesByRootProcessInstanceId(rootProcessInstanceId, removalTime, null, Collections.emptySet());
    }

    public Map<Class<? extends DbEntity>, DbOperation> addRemovalTimeToProcessInstancesByRootProcessInstanceId(String rootProcessInstanceId, Date removalTime, Integer batchSize, Set<String> entities) {
        HashMap<Class<? extends DbEntity>, DbOperation> updateOperations = new HashMap<Class<? extends DbEntity>, DbOperation>();
        CommandContext commandContext = this.getCommandContext();
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, HistoricActivityInstanceEventEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getHistoricActivityInstanceManager().addRemovalTimeToActivityInstancesByRootProcessInstanceId(rootProcessInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, HistoricTaskInstanceEventEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getHistoricTaskInstanceManager().addRemovalTimeToTaskInstancesByRootProcessInstanceId(rootProcessInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, HistoricVariableInstanceEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getHistoricVariableInstanceManager().addRemovalTimeToVariableInstancesByRootProcessInstanceId(rootProcessInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, HistoricDetailEventEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getHistoricDetailManager().addRemovalTimeToDetailsByRootProcessInstanceId(rootProcessInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, HistoricIncidentEventEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getHistoricIncidentManager().addRemovalTimeToIncidentsByRootProcessInstanceId(rootProcessInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, HistoricExternalTaskLogEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getHistoricExternalTaskLogManager().addRemovalTimeToExternalTaskLogByRootProcessInstanceId(rootProcessInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, HistoricJobLogEventEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getHistoricJobLogManager().addRemovalTimeToJobLogByRootProcessInstanceId(rootProcessInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, UserOperationLogEntryEventEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getOperationLogManager().addRemovalTimeToUserOperationLogByRootProcessInstanceId(rootProcessInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, HistoricIdentityLinkLogEventEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getHistoricIdentityLinkManager().addRemovalTimeToIdentityLinkLogByRootProcessInstanceId(rootProcessInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, CommentEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getCommentManager().addRemovalTimeToCommentsByRootProcessInstanceId(rootProcessInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, AttachmentEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getAttachmentManager().addRemovalTimeToAttachmentsByRootProcessInstanceId(rootProcessInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, ByteArrayEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getByteArrayManager().addRemovalTimeToByteArraysByRootProcessInstanceId(rootProcessInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isEnableHistoricInstancePermissions() && HistoricProcessInstanceManager.isPerformUpdate(entities, AuthorizationEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getAuthorizationManager().addRemovalTimeToAuthorizationsByRootProcessInstanceId(rootProcessInstanceId, removalTime, batchSize), updateOperations);
        }
        if (batchSize == null || HistoricProcessInstanceManager.isPerformUpdateOnly(entities, HistoricProcessInstanceEventEntity.class)) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("rootProcessInstanceId", rootProcessInstanceId);
            parameters.put("removalTime", removalTime);
            parameters.put("maxResults", batchSize);
            HistoricProcessInstanceManager.addOperation(this.getDbEntityManager().updatePreserveOrder(HistoricProcessInstanceEventEntity.class, "updateHistoricProcessInstanceEventsByRootProcessInstanceId", parameters), updateOperations);
        }
        return updateOperations;
    }

    public Map<Class<? extends DbEntity>, DbOperation> addRemovalTimeById(String processInstanceId, Date removalTime, Integer batchSize, Set<String> entities) {
        HashMap<Class<? extends DbEntity>, DbOperation> updateOperations = new HashMap<Class<? extends DbEntity>, DbOperation>();
        CommandContext commandContext = this.getCommandContext();
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, HistoricActivityInstanceEventEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getHistoricActivityInstanceManager().addRemovalTimeToActivityInstancesByProcessInstanceId(processInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, HistoricTaskInstanceEventEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getHistoricTaskInstanceManager().addRemovalTimeToTaskInstancesByProcessInstanceId(processInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, HistoricVariableInstanceEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getHistoricVariableInstanceManager().addRemovalTimeToVariableInstancesByProcessInstanceId(processInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, HistoricDetailEventEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getHistoricDetailManager().addRemovalTimeToDetailsByProcessInstanceId(processInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, HistoricIncidentEventEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getHistoricIncidentManager().addRemovalTimeToIncidentsByProcessInstanceId(processInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, HistoricExternalTaskLogEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getHistoricExternalTaskLogManager().addRemovalTimeToExternalTaskLogByProcessInstanceId(processInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, HistoricJobLogEventEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getHistoricJobLogManager().addRemovalTimeToJobLogByProcessInstanceId(processInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, UserOperationLogEntryEventEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getOperationLogManager().addRemovalTimeToUserOperationLogByProcessInstanceId(processInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, HistoricIdentityLinkLogEventEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getHistoricIdentityLinkManager().addRemovalTimeToIdentityLinkLogByProcessInstanceId(processInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, CommentEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getCommentManager().addRemovalTimeToCommentsByProcessInstanceId(processInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, AttachmentEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getAttachmentManager().addRemovalTimeToAttachmentsByProcessInstanceId(processInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isPerformUpdate(entities, ByteArrayEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getByteArrayManager().addRemovalTimeToByteArraysByProcessInstanceId(processInstanceId, removalTime, batchSize), updateOperations);
        }
        if (HistoricProcessInstanceManager.isEnableHistoricInstancePermissions() && HistoricProcessInstanceManager.isPerformUpdate(entities, AuthorizationEntity.class)) {
            HistoricProcessInstanceManager.addOperation(commandContext.getAuthorizationManager().addRemovalTimeToAuthorizationsByProcessInstanceId(processInstanceId, removalTime, batchSize), updateOperations);
        }
        if (batchSize == null || HistoricProcessInstanceManager.isPerformUpdateOnly(entities, HistoricProcessInstanceEventEntity.class)) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("processInstanceId", processInstanceId);
            parameters.put("removalTime", removalTime);
            parameters.put("maxResults", batchSize);
            HistoricProcessInstanceManager.addOperation(this.getDbEntityManager().updatePreserveOrder(HistoricProcessInstanceEventEntity.class, "updateHistoricProcessInstanceByProcessInstanceId", parameters), updateOperations);
        }
        return updateOperations;
    }

    public Map<Class<? extends DbEntity>, DbOperation> deleteHistoricProcessInstancesByRemovalTime(Date removalTime, int minuteFrom, int minuteTo, int batchSize) {
        CommandContext commandContext = this.getCommandContext();
        HashMap<Class<? extends DbEntity>, DbOperation> deleteOperations = new HashMap<Class<? extends DbEntity>, DbOperation>();
        DbOperation deleteActivityInstances = commandContext.getHistoricActivityInstanceManager().deleteHistoricActivityInstancesByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteActivityInstances.getEntityType(), deleteActivityInstances);
        DbOperation deleteTaskInstances = commandContext.getHistoricTaskInstanceManager().deleteHistoricTaskInstancesByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteTaskInstances.getEntityType(), deleteTaskInstances);
        DbOperation deleteVariableInstances = commandContext.getHistoricVariableInstanceManager().deleteHistoricVariableInstancesByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteVariableInstances.getEntityType(), deleteVariableInstances);
        DbOperation deleteDetails = commandContext.getHistoricDetailManager().deleteHistoricDetailsByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteDetails.getEntityType(), deleteDetails);
        DbOperation deleteIncidents = commandContext.getHistoricIncidentManager().deleteHistoricIncidentsByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteIncidents.getEntityType(), deleteIncidents);
        DbOperation deleteTaskLog = commandContext.getHistoricExternalTaskLogManager().deleteExternalTaskLogByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteTaskLog.getEntityType(), deleteTaskLog);
        DbOperation deleteJobLog = commandContext.getHistoricJobLogManager().deleteJobLogByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteJobLog.getEntityType(), deleteJobLog);
        DbOperation deleteOperationLog = commandContext.getOperationLogManager().deleteOperationLogByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteOperationLog.getEntityType(), deleteOperationLog);
        DbOperation deleteIdentityLinkLog = commandContext.getHistoricIdentityLinkManager().deleteHistoricIdentityLinkLogByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteIdentityLinkLog.getEntityType(), deleteIdentityLinkLog);
        DbOperation deleteComments = commandContext.getCommentManager().deleteCommentsByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteComments.getEntityType(), deleteComments);
        DbOperation deleteAttachments = commandContext.getAttachmentManager().deleteAttachmentsByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteAttachments.getEntityType(), deleteAttachments);
        DbOperation deleteByteArrays = commandContext.getByteArrayManager().deleteByteArraysByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteByteArrays.getEntityType(), deleteByteArrays);
        DbOperation deleteAuthorizations = commandContext.getAuthorizationManager().deleteAuthorizationsByRemovalTime(removalTime, minuteFrom, minuteTo, batchSize);
        deleteOperations.put(deleteAuthorizations.getEntityType(), deleteAuthorizations);
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("removalTime", removalTime);
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        parameters.put("batchSize", Integer.valueOf(batchSize));
        DbBulkOperation deleteProcessInstances = this.getDbEntityManager().deletePreserveOrder(HistoricProcessInstanceEntity.class, "deleteHistoricProcessInstancesByRemovalTime", new ListQueryParameterObject(parameters, 0, batchSize));
        deleteOperations.put(deleteProcessInstances.getEntityType(), deleteProcessInstances);
        return deleteOperations;
    }

    protected void configureQuery(HistoricProcessInstanceQueryImpl query) {
        this.getAuthorizationManager().configureHistoricProcessInstanceQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    protected static boolean isEnableHistoricInstancePermissions() {
        return Context.getProcessEngineConfiguration().isEnableHistoricInstancePermissions();
    }
}

