/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.List;
import org.eximeebpms.bpm.engine.authorization.Permissions;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.history.HistoricActivityStatistics;
import org.eximeebpms.bpm.engine.history.HistoricCaseActivityStatistics;
import org.eximeebpms.bpm.engine.impl.HistoricActivityStatisticsQueryImpl;
import org.eximeebpms.bpm.engine.impl.HistoricCaseActivityStatisticsQueryImpl;
import org.eximeebpms.bpm.engine.impl.Page;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.AbstractManager;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;

public class HistoricStatisticsManager
extends AbstractManager {
    public List<HistoricActivityStatistics> getHistoricStatisticsGroupedByActivity(HistoricActivityStatisticsQueryImpl query, Page page) {
        if (this.ensureHistoryReadOnProcessDefinition(query)) {
            return this.getDbEntityManager().selectList("selectHistoricActivityStatistics", query, page);
        }
        return new ArrayList<HistoricActivityStatistics>();
    }

    public long getHistoricStatisticsCountGroupedByActivity(HistoricActivityStatisticsQueryImpl query) {
        if (this.ensureHistoryReadOnProcessDefinition(query)) {
            return (Long)this.getDbEntityManager().selectOne("selectHistoricActivityStatisticsCount", query);
        }
        return 0L;
    }

    public List<HistoricCaseActivityStatistics> getHistoricStatisticsGroupedByCaseActivity(HistoricCaseActivityStatisticsQueryImpl query, Page page) {
        return this.getDbEntityManager().selectList("selectHistoricCaseActivityStatistics", query, page);
    }

    public long getHistoricStatisticsCountGroupedByCaseActivity(HistoricCaseActivityStatisticsQueryImpl query) {
        return (Long)this.getDbEntityManager().selectOne("selectHistoricCaseActivityStatisticsCount", query);
    }

    protected boolean ensureHistoryReadOnProcessDefinition(HistoricActivityStatisticsQueryImpl query) {
        CommandContext commandContext = this.getCommandContext();
        if (this.isAuthorizationEnabled() && this.getCurrentAuthentication() != null && commandContext.isAuthorizationCheckEnabled()) {
            String processDefinitionId = query.getProcessDefinitionId();
            ProcessDefinitionEntity definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
            if (definition == null) {
                return false;
            }
            return this.getAuthorizationManager().isAuthorized(Permissions.READ_HISTORY, Resources.PROCESS_DEFINITION, definition.getKey());
        }
        return true;
    }
}

