/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import org.eximeebpms.bpm.engine.impl.JobDefinitionQueryImpl;
import org.eximeebpms.bpm.engine.impl.Page;
import org.eximeebpms.bpm.engine.impl.db.ListQueryParameterObject;
import org.eximeebpms.bpm.engine.impl.persistence.AbstractManager;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.SuspensionState;
import org.eximeebpms.bpm.engine.management.JobDefinition;

public class JobDefinitionManager
extends AbstractManager {
    public JobDefinitionEntity findById(String jobDefinitionId) {
        return this.getDbEntityManager().selectById(JobDefinitionEntity.class, jobDefinitionId);
    }

    public List<JobDefinitionEntity> findByProcessDefinitionId(String processDefinitionId) {
        return this.getDbEntityManager().selectList("selectJobDefinitionsByProcessDefinitionId", processDefinitionId);
    }

    public void deleteJobDefinitionsByProcessDefinitionId(String id) {
        this.getDbEntityManager().delete(JobDefinitionEntity.class, "deleteJobDefinitionsByProcessDefinitionId", id);
    }

    public List<JobDefinition> findJobDefnitionByQueryCriteria(JobDefinitionQueryImpl jobDefinitionQuery, Page page) {
        this.configureQuery(jobDefinitionQuery);
        return this.getDbEntityManager().selectList("selectJobDefinitionByQueryCriteria", jobDefinitionQuery, page);
    }

    public long findJobDefinitionCountByQueryCriteria(JobDefinitionQueryImpl jobDefinitionQuery) {
        this.configureQuery(jobDefinitionQuery);
        return (Long)this.getDbEntityManager().selectOne("selectJobDefinitionCountByQueryCriteria", jobDefinitionQuery);
    }

    public void updateJobDefinitionSuspensionStateById(String jobDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("jobDefinitionId", jobDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(JobDefinitionEntity.class, "updateJobDefinitionSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateJobDefinitionSuspensionStateByProcessDefinitionId(String processDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(JobDefinitionEntity.class, "updateJobDefinitionSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateJobDefinitionSuspensionStateByProcessDefinitionKey(String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isProcessDefinitionTenantIdSet", false);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(JobDefinitionEntity.class, "updateJobDefinitionSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateJobDefinitionSuspensionStateByProcessDefinitionKeyAndTenantId(String processDefinitionKey, String processDefinitionTenantId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isProcessDefinitionTenantIdSet", true);
        parameters.put("processDefinitionTenantId", processDefinitionTenantId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(JobDefinitionEntity.class, "updateJobDefinitionSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    protected void configureQuery(JobDefinitionQueryImpl query) {
        this.getAuthorizationManager().configureJobDefinitionQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    protected ListQueryParameterObject configureParameterizedQuery(Object parameter) {
        return this.getTenantManager().configureQuery(parameter);
    }
}

