/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.impl.Page;
import org.eximeebpms.bpm.engine.impl.TaskQueryImpl;
import org.eximeebpms.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.db.ListQueryParameterObject;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.AbstractManager;
import org.eximeebpms.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.SuspensionState;
import org.eximeebpms.bpm.engine.impl.persistence.entity.TaskEntity;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;
import org.eximeebpms.bpm.engine.task.Task;

public class TaskManager
extends AbstractManager {
    public void insertTask(TaskEntity task) {
        this.getDbEntityManager().insert(task);
        this.createDefaultAuthorizations(task);
    }

    public void deleteTasksByProcessInstanceId(String processInstanceId, String deleteReason, boolean cascade, boolean skipCustomListeners) {
        List tasks = this.getDbEntityManager().createTaskQuery().processInstanceId(processInstanceId).list();
        String reason = deleteReason == null || deleteReason.length() == 0 ? "deleted" : deleteReason;
        for (TaskEntity task : tasks) {
            task.delete(reason, cascade, skipCustomListeners);
        }
    }

    public void deleteTasksByCaseInstanceId(String caseInstanceId, String deleteReason, boolean cascade) {
        List tasks = this.getDbEntityManager().createTaskQuery().caseInstanceId(caseInstanceId).list();
        String reason = deleteReason == null || deleteReason.length() == 0 ? "deleted" : deleteReason;
        for (TaskEntity task : tasks) {
            task.delete(reason, cascade, false);
        }
    }

    public void deleteTask(TaskEntity task, String deleteReason, boolean cascade, boolean skipCustomListeners) {
        if (!task.isDeleted()) {
            task.setDeleted(true);
            CommandContext commandContext = Context.getCommandContext();
            String taskId = task.getId();
            List<Task> subTasks = this.findTasksByParentTaskId(taskId);
            for (Task subTask : subTasks) {
                ((TaskEntity)subTask).delete(deleteReason, cascade, skipCustomListeners);
            }
            task.deleteIdentityLinks();
            commandContext.getVariableInstanceManager().deleteVariableInstanceByTask(task);
            if (cascade) {
                commandContext.getHistoricTaskInstanceManager().deleteHistoricTaskInstanceById(taskId);
            } else {
                commandContext.getHistoricTaskInstanceManager().markTaskInstanceEnded(taskId, deleteReason);
            }
            this.deleteAuthorizations(Resources.TASK, taskId);
            this.getDbEntityManager().delete(task);
        }
    }

    public TaskEntity findTaskById(String id) {
        EnsureUtil.ensureNotNull("Invalid task id", "id", (Object)id);
        return this.getDbEntityManager().selectById(TaskEntity.class, id);
    }

    public List<TaskEntity> findTasksByExecutionId(String executionId) {
        return this.getDbEntityManager().selectList("selectTasksByExecutionId", executionId);
    }

    public TaskEntity findTaskByCaseExecutionId(String caseExecutionId) {
        return (TaskEntity)this.getDbEntityManager().selectOne("selectTaskByCaseExecutionId", caseExecutionId);
    }

    public List<TaskEntity> findTasksByProcessInstanceId(String processInstanceId) {
        return this.getDbEntityManager().selectList("selectTasksByProcessInstanceId", processInstanceId);
    }

    @Deprecated
    public List<Task> findTasksByQueryCriteria(TaskQueryImpl taskQuery, Page page) {
        taskQuery.setFirstResult(page.getFirstResult());
        taskQuery.setMaxResults(page.getMaxResults());
        return this.findTasksByQueryCriteria(taskQuery);
    }

    public List<Task> findTasksByQueryCriteria(TaskQueryImpl taskQuery) {
        this.configureQuery(taskQuery);
        return this.getDbEntityManager().selectList("selectTaskByQueryCriteria", taskQuery);
    }

    public long findTaskCountByQueryCriteria(TaskQueryImpl taskQuery) {
        this.configureQuery(taskQuery);
        return (Long)this.getDbEntityManager().selectOne("selectTaskCountByQueryCriteria", taskQuery);
    }

    public List<Task> findTasksByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbEntityManager().selectListWithRawParameter("selectTaskByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findTaskCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbEntityManager().selectOne("selectTaskCountByNativeQuery", parameterMap);
    }

    public List<Task> findTasksByParentTaskId(String parentTaskId) {
        return this.getDbEntityManager().selectList("selectTasksByParentTaskId", parentTaskId);
    }

    public void updateTaskSuspensionStateByProcessDefinitionId(String processDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(TaskEntity.class, "updateTaskSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateTaskSuspensionStateByProcessInstanceId(String processInstanceId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(TaskEntity.class, "updateTaskSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateTaskSuspensionStateByProcessDefinitionKey(String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isProcessDefinitionTenantIdSet", false);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(TaskEntity.class, "updateTaskSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateTaskSuspensionStateByProcessDefinitionKeyAndTenantId(String processDefinitionKey, String processDefinitionTenantId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isProcessDefinitionTenantIdSet", true);
        parameters.put("processDefinitionTenantId", processDefinitionTenantId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(TaskEntity.class, "updateTaskSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateTaskSuspensionStateByCaseExecutionId(String caseExecutionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseExecutionId", caseExecutionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(TaskEntity.class, "updateTaskSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    protected void createDefaultAuthorizations(TaskEntity task) {
        if (this.isAuthorizationEnabled()) {
            ResourceAuthorizationProvider provider = this.getResourceAuthorizationProvider();
            AuthorizationEntity[] authorizations = provider.newTask(task);
            this.saveDefaultAuthorizations(authorizations);
        }
    }

    protected void configureQuery(TaskQueryImpl query) {
        this.getAuthorizationManager().configureTaskQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    protected ListQueryParameterObject configureParameterizedQuery(Object parameter) {
        return this.getTenantManager().configureQuery(parameter);
    }
}

