/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.pvm.runtime.operation;

import java.util.List;
import org.eximeebpms.bpm.engine.impl.pvm.PvmTransition;
import org.eximeebpms.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.eximeebpms.bpm.engine.impl.pvm.delegate.ModificationObserverBehavior;
import org.eximeebpms.bpm.engine.impl.pvm.process.ActivityImpl;
import org.eximeebpms.bpm.engine.impl.pvm.process.ScopeImpl;
import org.eximeebpms.bpm.engine.impl.pvm.process.TransitionImpl;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.InstantiationStack;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.ScopeInstantiationContext;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperationActivityInstanceStart;

public class PvmAtomicOperationActivityInitStackNotifyListenerStart
extends PvmAtomicOperationActivityInstanceStart {
    @Override
    public String getCanonicalName() {
        return "activity-init-stack-notify-listener-start";
    }

    @Override
    protected ScopeImpl getScope(PvmExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        if (activity != null) {
            return activity;
        }
        PvmExecutionImpl parent = execution.getParent();
        if (parent != null) {
            return this.getScope(execution.getParent());
        }
        return execution.getProcessDefinition();
    }

    @Override
    protected String getEventName() {
        return "start";
    }

    @Override
    protected void eventNotificationsCompleted(PvmExecutionImpl execution) {
        super.eventNotificationsCompleted(execution);
        execution.activityInstanceStarted();
        ScopeInstantiationContext startContext = execution.getScopeInstantiationContext();
        InstantiationStack instantiationStack = startContext.getInstantiationStack();
        PvmExecutionImpl propagatingExecution = execution;
        ActivityImpl activity = execution.getActivity();
        if (activity.getActivityBehavior() instanceof ModificationObserverBehavior) {
            ModificationObserverBehavior behavior = (ModificationObserverBehavior)activity.getActivityBehavior();
            List<ActivityExecution> concurrentExecutions = behavior.initializeScope(propagatingExecution, 1);
            propagatingExecution = (PvmExecutionImpl)concurrentExecutions.get(0);
        }
        if (instantiationStack.getActivities().isEmpty() && instantiationStack.getTargetActivity() != null) {
            propagatingExecution.setActivityInstanceId(null);
            startContext.applyVariables(propagatingExecution);
            propagatingExecution.setActivity(instantiationStack.getTargetActivity());
            propagatingExecution.disposeScopeInstantiationContext();
            propagatingExecution.performOperation(ACTIVITY_START_CREATE_SCOPE);
        } else if (instantiationStack.getActivities().isEmpty() && instantiationStack.getTargetTransition() != null) {
            propagatingExecution.setActivityInstanceId(null);
            PvmTransition transition = instantiationStack.getTargetTransition();
            startContext.applyVariables(propagatingExecution);
            propagatingExecution.setActivity(transition.getSource());
            propagatingExecution.setTransition((TransitionImpl)transition);
            propagatingExecution.disposeScopeInstantiationContext();
            propagatingExecution.performOperation(TRANSITION_START_NOTIFY_LISTENER_TAKE);
        } else {
            propagatingExecution.setActivity(null);
            propagatingExecution.performOperation(ACTIVITY_INIT_STACK);
        }
    }
}

