/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.pvm.runtime.operation;

import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.pvm.PvmActivity;
import org.eximeebpms.bpm.engine.impl.pvm.process.ActivityImpl;
import org.eximeebpms.bpm.engine.impl.pvm.process.ScopeImpl;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.CompensationBehavior;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperationActivityInstanceEnd;

public class PvmAtomicOperationDeleteCascadeFireActivityEnd
extends PvmAtomicOperationActivityInstanceEnd {
    @Override
    protected PvmExecutionImpl eventNotificationsStarted(PvmExecutionImpl execution) {
        execution.setCanceled(true);
        return super.eventNotificationsStarted(execution);
    }

    @Override
    protected ScopeImpl getScope(PvmExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        if (activity != null) {
            return activity;
        }
        PvmExecutionImpl parent = execution.getParent();
        if (parent != null) {
            return this.getScope(execution.getParent());
        }
        return execution.getProcessDefinition();
    }

    @Override
    protected String getEventName() {
        return "end";
    }

    @Override
    protected void eventNotificationsCompleted(PvmExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        if (execution.isScope() && (this.executesNonScopeActivity(execution) || this.isAsyncBeforeActivity(execution)) && !CompensationBehavior.executesNonScopeCompensationHandler(execution)) {
            execution.removeAllTasks();
            execution.leaveActivityInstance();
            execution.setActivity(this.getFlowScopeActivity(activity));
            execution.performOperation(DELETE_CASCADE_FIRE_ACTIVITY_END);
        } else {
            boolean continueRemoval;
            if (execution.isScope()) {
                ProcessEngineConfigurationImpl engineConfiguration = Context.getProcessEngineConfiguration();
                boolean alwaysSkipIoMappings = execution instanceof ExecutionEntity && !execution.isProcessInstanceExecution() && execution.isCanceled() && engineConfiguration.isSkipOutputMappingOnCanceledActivities();
                execution.destroy(alwaysSkipIoMappings);
            }
            execution.remove();
            boolean bl = continueRemoval = !execution.isDeleteRoot();
            if (continueRemoval) {
                PvmExecutionImpl propagatingExecution = execution.getParent();
                if (propagatingExecution != null && !propagatingExecution.isScope() && !propagatingExecution.hasChildren()) {
                    propagatingExecution.remove();
                    continueRemoval = !propagatingExecution.isDeleteRoot();
                    propagatingExecution = propagatingExecution.getParent();
                }
                if (continueRemoval && propagatingExecution != null && propagatingExecution.getActivity() == null && activity != null && activity.getFlowScope() != null) {
                    propagatingExecution.setActivity(this.getFlowScopeActivity(activity));
                }
            }
        }
    }

    protected boolean executesNonScopeActivity(PvmExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        return activity != null && !activity.isScope();
    }

    protected boolean isAsyncBeforeActivity(PvmExecutionImpl execution) {
        return execution.getActivityId() != null && execution.getActivityInstanceId() == null;
    }

    protected ActivityImpl getFlowScopeActivity(PvmActivity activity) {
        ScopeImpl flowScope = activity.getFlowScope();
        ActivityImpl flowScopeActivity = null;
        if (flowScope.getProcessDefinition() != flowScope) {
            flowScopeActivity = (ActivityImpl)flowScope;
        }
        return flowScopeActivity;
    }

    @Override
    public String getCanonicalName() {
        return "delete-cascade-fire-activity-end";
    }
}

