/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.pvm.runtime.operation;

import org.eximeebpms.bpm.engine.impl.pvm.process.ScopeImpl;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.Callback;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.operation.AbstractPvmEventAtomicOperation;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;

public class PvmAtomicOperationProcessStart
extends AbstractPvmEventAtomicOperation {
    @Override
    public boolean isAsync(PvmExecutionImpl execution) {
        return execution.getActivity().isAsyncBefore();
    }

    @Override
    public boolean isAsyncCapable() {
        return true;
    }

    @Override
    protected ScopeImpl getScope(PvmExecutionImpl execution) {
        return execution.getProcessDefinition();
    }

    @Override
    protected String getEventName() {
        return "start";
    }

    @Override
    protected PvmExecutionImpl eventNotificationsStarted(PvmExecutionImpl execution) {
        execution.setProcessInstanceStarting(true);
        if (execution.getActivity() != null && execution.getActivity().isAsyncBefore()) {
            LegacyBehavior.createMissingHistoricVariables(execution);
        }
        return execution;
    }

    @Override
    protected void eventNotificationsCompleted(PvmExecutionImpl execution) {
        execution.continueIfExecutionDoesNotAffectNextOperation(new Callback<PvmExecutionImpl, Void>(){

            @Override
            public Void callback(PvmExecutionImpl execution) {
                execution.dispatchEvent(null);
                return null;
            }
        }, new Callback<PvmExecutionImpl, Void>(){

            @Override
            public Void callback(PvmExecutionImpl execution) {
                execution.setIgnoreAsync(true);
                execution.performOperation(PvmAtomicOperation.ACTIVITY_START_CREATE_SCOPE);
                return null;
            }
        }, execution);
    }

    @Override
    public String getCanonicalName() {
        return "process-start";
    }
}

