/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.repository;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.RepositoryServiceImpl;
import org.eximeebpms.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.eximeebpms.bpm.engine.impl.cmd.CommandLogger;
import org.eximeebpms.bpm.engine.impl.cmmn.deployer.CmmnDeployer;
import org.eximeebpms.bpm.engine.impl.dmn.deployer.DecisionDefinitionDeployer;
import org.eximeebpms.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.eximeebpms.bpm.engine.impl.util.CollectionUtil;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;
import org.eximeebpms.bpm.engine.impl.util.IoUtil;
import org.eximeebpms.bpm.engine.impl.util.ReflectUtil;
import org.eximeebpms.bpm.engine.impl.util.StringUtil;
import org.eximeebpms.bpm.engine.repository.Deployment;
import org.eximeebpms.bpm.engine.repository.DeploymentBuilder;
import org.eximeebpms.bpm.engine.repository.DeploymentWithDefinitions;
import org.eximeebpms.bpm.model.bpmn.Bpmn;
import org.eximeebpms.bpm.model.bpmn.BpmnModelInstance;
import org.eximeebpms.bpm.model.cmmn.Cmmn;
import org.eximeebpms.bpm.model.cmmn.CmmnModelInstance;
import org.eximeebpms.bpm.model.dmn.Dmn;
import org.eximeebpms.bpm.model.dmn.DmnModelInstance;

public class DeploymentBuilderImpl
implements DeploymentBuilder,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected transient RepositoryServiceImpl repositoryService;
    protected DeploymentEntity deployment = new DeploymentEntity();
    protected boolean isDuplicateFilterEnabled = false;
    protected boolean deployChangedOnly = false;
    protected Date processDefinitionsActivationDate;
    protected String nameFromDeployment;
    protected Set<String> deployments = new HashSet<String>();
    protected Map<String, Set<String>> deploymentResourcesById = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> deploymentResourcesByName = new HashMap<String, Set<String>>();

    public DeploymentBuilderImpl(RepositoryServiceImpl repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Override
    public DeploymentBuilder addInputStream(String resourceName, InputStream inputStream) {
        EnsureUtil.ensureNotNull("inputStream for resource '" + resourceName + "' is null", "inputStream", (Object)inputStream);
        byte[] bytes = IoUtil.readInputStream(inputStream, resourceName);
        return this.addBytes(resourceName, bytes);
    }

    @Override
    public DeploymentBuilder addClasspathResource(String resource) {
        InputStream inputStream = ReflectUtil.getResourceAsStream(resource);
        EnsureUtil.ensureNotNull("resource '" + resource + "' not found", "inputStream", (Object)inputStream);
        return this.addInputStream(resource, inputStream);
    }

    @Override
    public DeploymentBuilder addString(String resourceName, String text) {
        EnsureUtil.ensureNotNull("text", (Object)text);
        byte[] bytes = this.repositoryService != null && this.repositoryService.getDeploymentCharset() != null ? text.getBytes(this.repositoryService.getDeploymentCharset()) : text.getBytes();
        return this.addBytes(resourceName, bytes);
    }

    @Override
    public DeploymentBuilder addModelInstance(String resourceName, CmmnModelInstance modelInstance) {
        EnsureUtil.ensureNotNull("modelInstance", (Object)modelInstance);
        this.validateResouceName(resourceName, CmmnDeployer.CMMN_RESOURCE_SUFFIXES);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Cmmn.writeModelToStream((OutputStream)outputStream, (CmmnModelInstance)modelInstance);
        return this.addBytes(resourceName, outputStream.toByteArray());
    }

    @Override
    public DeploymentBuilder addModelInstance(String resourceName, BpmnModelInstance modelInstance) {
        EnsureUtil.ensureNotNull("modelInstance", (Object)modelInstance);
        this.validateResouceName(resourceName, BpmnDeployer.BPMN_RESOURCE_SUFFIXES);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Bpmn.writeModelToStream((OutputStream)outputStream, (BpmnModelInstance)modelInstance);
        return this.addBytes(resourceName, outputStream.toByteArray());
    }

    @Override
    public DeploymentBuilder addModelInstance(String resourceName, DmnModelInstance modelInstance) {
        EnsureUtil.ensureNotNull("modelInstance", (Object)modelInstance);
        this.validateResouceName(resourceName, DecisionDefinitionDeployer.DMN_RESOURCE_SUFFIXES);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Dmn.writeModelToStream((OutputStream)outputStream, (DmnModelInstance)modelInstance);
        return this.addBytes(resourceName, outputStream.toByteArray());
    }

    private void validateResouceName(String resourceName, String[] resourceSuffixes) {
        if (!StringUtil.hasAnySuffix(resourceName, resourceSuffixes)) {
            LOG.warnDeploymentResourceHasWrongName(resourceName, resourceSuffixes);
        }
    }

    protected DeploymentBuilder addBytes(String resourceName, byte[] bytes) {
        ResourceEntity resource = new ResourceEntity();
        resource.setBytes(bytes);
        resource.setName(resourceName);
        this.deployment.addResource(resource);
        return this;
    }

    @Override
    public DeploymentBuilder addZipInputStream(ZipInputStream zipInputStream) {
        try {
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    String entryName = entry.getName();
                    this.addInputStream(entryName, zipInputStream);
                }
                entry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception e) {
            throw new ProcessEngineException("problem reading zip input stream", e);
        }
        return this;
    }

    @Override
    public DeploymentBuilder addDeploymentResources(String deploymentId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "deploymentId", (Object)deploymentId);
        this.deployments.add(deploymentId);
        return this;
    }

    @Override
    public DeploymentBuilder addDeploymentResourceById(String deploymentId, String resourceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "deploymentId", (Object)deploymentId);
        EnsureUtil.ensureNotNull(NotValidException.class, "resourceId", (Object)resourceId);
        CollectionUtil.addToMapOfSets(this.deploymentResourcesById, deploymentId, resourceId);
        return this;
    }

    @Override
    public DeploymentBuilder addDeploymentResourcesById(String deploymentId, List<String> resourceIds) {
        EnsureUtil.ensureNotNull(NotValidException.class, "deploymentId", (Object)deploymentId);
        EnsureUtil.ensureNotNull(NotValidException.class, "resourceIds", resourceIds);
        EnsureUtil.ensureNotEmpty(NotValidException.class, "resourceIds", resourceIds);
        EnsureUtil.ensureNotContainsNull(NotValidException.class, "resourceIds", resourceIds);
        CollectionUtil.addCollectionToMapOfSets(this.deploymentResourcesById, deploymentId, resourceIds);
        return this;
    }

    @Override
    public DeploymentBuilder addDeploymentResourceByName(String deploymentId, String resourceName) {
        EnsureUtil.ensureNotNull(NotValidException.class, "deploymentId", (Object)deploymentId);
        EnsureUtil.ensureNotNull(NotValidException.class, "resourceName", (Object)resourceName);
        CollectionUtil.addToMapOfSets(this.deploymentResourcesByName, deploymentId, resourceName);
        return this;
    }

    @Override
    public DeploymentBuilder addDeploymentResourcesByName(String deploymentId, List<String> resourceNames) {
        EnsureUtil.ensureNotNull(NotValidException.class, "deploymentId", (Object)deploymentId);
        EnsureUtil.ensureNotNull(NotValidException.class, "resourceNames", resourceNames);
        EnsureUtil.ensureNotEmpty(NotValidException.class, "resourceNames", resourceNames);
        EnsureUtil.ensureNotContainsNull(NotValidException.class, "resourceNames", resourceNames);
        CollectionUtil.addCollectionToMapOfSets(this.deploymentResourcesByName, deploymentId, resourceNames);
        return this;
    }

    @Override
    public DeploymentBuilder name(String name) {
        if (this.nameFromDeployment != null && !this.nameFromDeployment.isEmpty()) {
            String message = String.format("Cannot set the deployment name to '%s', because the property 'nameForDeployment' has been already set to '%s'.", name, this.nameFromDeployment);
            throw new NotValidException(message);
        }
        this.deployment.setName(name);
        return this;
    }

    @Override
    public DeploymentBuilder nameFromDeployment(String deploymentId) {
        String name = this.deployment.getName();
        if (name != null && !name.isEmpty()) {
            String message = String.format("Cannot set the given deployment id '%s' to get the name from it, because the deployment name has been already set to '%s'.", deploymentId, name);
            throw new NotValidException(message);
        }
        this.nameFromDeployment = deploymentId;
        return this;
    }

    @Override
    public DeploymentBuilder enableDuplicateFiltering() {
        return this.enableDuplicateFiltering(false);
    }

    @Override
    public DeploymentBuilder enableDuplicateFiltering(boolean deployChangedOnly) {
        this.isDuplicateFilterEnabled = true;
        this.deployChangedOnly = deployChangedOnly;
        return this;
    }

    @Override
    public DeploymentBuilder activateProcessDefinitionsOn(Date date) {
        this.processDefinitionsActivationDate = date;
        return this;
    }

    @Override
    public DeploymentBuilder source(String source) {
        this.deployment.setSource(source);
        return this;
    }

    @Override
    public DeploymentBuilder tenantId(String tenantId) {
        this.deployment.setTenantId(tenantId);
        return this;
    }

    @Override
    public Deployment deploy() {
        return this.deployWithResult();
    }

    @Override
    public DeploymentWithDefinitions deployWithResult() {
        return this.repositoryService.deployWithResult(this);
    }

    @Override
    public Collection<String> getResourceNames() {
        if (this.deployment.getResources() == null) {
            return Collections.emptySet();
        }
        return this.deployment.getResources().keySet();
    }

    public DeploymentEntity getDeployment() {
        return this.deployment;
    }

    public boolean isDuplicateFilterEnabled() {
        return this.isDuplicateFilterEnabled;
    }

    public boolean isDeployChangedOnly() {
        return this.deployChangedOnly;
    }

    public Date getProcessDefinitionsActivationDate() {
        return this.processDefinitionsActivationDate;
    }

    public String getNameFromDeployment() {
        return this.nameFromDeployment;
    }

    public Set<String> getDeployments() {
        return this.deployments;
    }

    public Map<String, Set<String>> getDeploymentResourcesById() {
        return this.deploymentResourcesById;
    }

    public Map<String, Set<String>> getDeploymentResourcesByName() {
        return this.deploymentResourcesByName;
    }
}

