/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.scripting;

import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.ScriptEvaluationException;
import org.eximeebpms.bpm.engine.delegate.DelegateExecution;
import org.eximeebpms.bpm.engine.delegate.VariableScope;
import org.eximeebpms.bpm.engine.impl.Condition;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.delegate.ScriptInvocation;
import org.eximeebpms.bpm.engine.impl.scripting.ExecutableScript;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class ScriptCondition
implements Condition {
    protected final ExecutableScript script;

    public ScriptCondition(ExecutableScript script) {
        this.script = script;
    }

    @Override
    public boolean evaluate(DelegateExecution execution) {
        return this.evaluate(execution, execution);
    }

    @Override
    public boolean evaluate(VariableScope scope, DelegateExecution execution) {
        ScriptInvocation invocation = new ScriptInvocation(this.script, scope, execution);
        try {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProcessEngineException(e);
        }
        Object result = invocation.getInvocationResult();
        EnsureUtil.ensureNotNull("condition script returns null", "result", result);
        EnsureUtil.ensureInstanceOf("condition script returns non-Boolean", "result", result, Boolean.class);
        return (Boolean)result;
    }

    @Override
    public boolean tryEvaluate(VariableScope scope, DelegateExecution execution) {
        boolean result;
        block2: {
            result = false;
            try {
                result = this.evaluate(scope, execution);
            }
            catch (ProcessEngineException pex) {
                if (pex.getMessage().contains("No such property") || pex.getCause() instanceof ScriptEvaluationException) break block2;
                throw pex;
            }
        }
        return result;
    }

    public ExecutableScript getScript() {
        return this.script;
    }
}

