/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.scripting.engine;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;

public class CamundaScriptEngineManager
extends ScriptEngineManager {
    protected final Map<String, Runnable> engineNameToInitLogicMappings = Map.of("Graal.js", this::disableGraalVMInterpreterOnlyModeWarnings);

    public CamundaScriptEngineManager() {
        this.applyConfigOnEnginesAfterClasspathDiscovery();
    }

    protected void applyConfigOnEnginesAfterClasspathDiscovery() {
        List<String> engineNames = this.getEngineNamesFoundInClasspath();
        for (String engineName : engineNames) {
            this.executeConfigurationBeforeEngineCreation(engineName);
        }
    }

    protected List<String> getEngineNamesFoundInClasspath() {
        List<ScriptEngineFactory> engineFactories = this.getEngineFactories();
        return engineFactories.stream().map(ScriptEngineFactory::getEngineName).collect(Collectors.toList());
    }

    protected void executeConfigurationBeforeEngineCreation(String engineName) {
        Runnable config = this.engineNameToInitLogicMappings.get(engineName);
        if (config != null) {
            config.run();
        }
    }

    protected void disableGraalVMInterpreterOnlyModeWarnings() {
        System.setProperty("polyglot.engine.WarnInterpreterOnly", "false");
    }
}

