/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.scripting.engine;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import org.eximeebpms.bpm.engine.delegate.VariableScope;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.scripting.engine.Resolver;

public class ScriptBindings
implements Bindings {
    protected static final Set<String> UNSTORED_KEYS = new HashSet<String>(Arrays.asList("out", "out:print", "lang:import", "context", "elcontext", "print", "println", "S", "XML", "JSON", "javax.script.argv", "execution", "__doc__"));
    protected List<Resolver> scriptResolvers;
    protected VariableScope variableScope;
    protected Bindings wrappedBindings;
    protected boolean autoStoreScriptVariables;

    public ScriptBindings(List<Resolver> scriptResolvers, VariableScope variableScope, Bindings wrappedBindings) {
        this.scriptResolvers = scriptResolvers;
        this.variableScope = variableScope;
        this.wrappedBindings = wrappedBindings;
        this.autoStoreScriptVariables = this.isAutoStoreScriptVariablesEnabled();
    }

    protected boolean isAutoStoreScriptVariablesEnabled() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration != null) {
            return processEngineConfiguration.isAutoStoreScriptVariables();
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        for (Resolver scriptResolver : this.scriptResolvers) {
            if (!scriptResolver.containsKey(key)) continue;
            return true;
        }
        return this.wrappedBindings.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        Object result = null;
        if (this.wrappedBindings.containsKey(key)) {
            result = this.wrappedBindings.get(key);
        } else {
            for (Resolver scriptResolver : this.scriptResolvers) {
                if (!scriptResolver.containsKey(key)) continue;
                result = scriptResolver.get(key);
            }
        }
        return result;
    }

    @Override
    public Object put(String name, Object value) {
        if (this.autoStoreScriptVariables && !UNSTORED_KEYS.contains(name)) {
            Object oldValue = this.variableScope.getVariable(name);
            this.variableScope.setVariable(name, value);
            return oldValue;
        }
        return this.wrappedBindings.put(name, value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.calculateBindingMap().entrySet();
    }

    @Override
    public Set<String> keySet() {
        return this.calculateBindingMap().keySet();
    }

    @Override
    public int size() {
        return this.calculateBindingMap().size();
    }

    @Override
    public Collection<Object> values() {
        return this.calculateBindingMap().values();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        for (Map.Entry<? extends String, ? extends Object> entry : toMerge.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        if (UNSTORED_KEYS.contains(key)) {
            return null;
        }
        return this.wrappedBindings.remove(key);
    }

    @Override
    public void clear() {
        this.wrappedBindings.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.calculateBindingMap().containsValue(value);
    }

    @Override
    public boolean isEmpty() {
        return this.calculateBindingMap().isEmpty();
    }

    protected Map<String, Object> calculateBindingMap() {
        HashMap<String, Object> bindingMap = new HashMap<String, Object>();
        for (Resolver resolver : this.scriptResolvers) {
            for (String key : resolver.keySet()) {
                bindingMap.put(key, resolver.get(key));
            }
        }
        Set wrappedBindingsEntries = this.wrappedBindings.entrySet();
        for (Map.Entry entry : wrappedBindingsEntries) {
            bindingMap.put((String)entry.getKey(), entry.getValue());
        }
        return bindingMap;
    }
}

