/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.scripting.env;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import org.eximeebpms.bpm.application.AbstractProcessApplication;
import org.eximeebpms.bpm.application.ProcessApplicationInterface;
import org.eximeebpms.bpm.application.ProcessApplicationReference;
import org.eximeebpms.bpm.application.ProcessApplicationUnavailableException;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.delegate.VariableScope;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.scripting.ExecutableScript;
import org.eximeebpms.bpm.engine.impl.scripting.ScriptFactory;
import org.eximeebpms.bpm.engine.impl.scripting.engine.ScriptingEngines;
import org.eximeebpms.bpm.engine.impl.scripting.env.ScriptEnvResolver;

public class ScriptingEnvironment {
    protected Map<String, List<ExecutableScript>> env = new HashMap<String, List<ExecutableScript>>();
    protected List<ScriptEnvResolver> envResolvers;
    protected ScriptFactory scriptFactory;
    protected ScriptingEngines scriptingEngines;

    public ScriptingEnvironment(ScriptFactory scriptFactory, List<ScriptEnvResolver> scriptEnvResolvers, ScriptingEngines scriptingEngines) {
        this.scriptFactory = scriptFactory;
        this.envResolvers = scriptEnvResolvers;
        this.scriptingEngines = scriptingEngines;
    }

    public Object execute(ExecutableScript script, VariableScope scope) {
        ScriptEngine scriptEngine = this.scriptingEngines.getScriptEngineForLanguage(script.getLanguage());
        Bindings bindings = this.scriptingEngines.createBindings(scriptEngine, scope);
        return this.execute(script, scope, bindings, scriptEngine);
    }

    public Object execute(ExecutableScript script, VariableScope scope, Bindings bindings, ScriptEngine scriptEngine) {
        List<ExecutableScript> envScripts = this.getEnvScripts(script, scriptEngine);
        for (ExecutableScript envScript : envScripts) {
            envScript.execute(scriptEngine, scope, bindings);
        }
        return script.execute(scriptEngine, scope, bindings);
    }

    protected Map<String, List<ExecutableScript>> getEnv(String language) {
        ProcessEngineConfigurationImpl config = Context.getProcessEngineConfiguration();
        ProcessApplicationReference processApplication = Context.getCurrentProcessApplication();
        Map<String, List<ExecutableScript>> result = null;
        if (config.isEnableFetchScriptEngineFromProcessApplication() && processApplication != null) {
            result = this.getPaEnvScripts(processApplication);
        }
        return result != null ? result : this.env;
    }

    protected Map<String, List<ExecutableScript>> getPaEnvScripts(ProcessApplicationReference pa) {
        try {
            ProcessApplicationInterface processApplication = pa.getProcessApplication();
            ProcessApplicationInterface rawObject = processApplication.getRawObject();
            if (rawObject instanceof AbstractProcessApplication) {
                AbstractProcessApplication abstractProcessApplication = (AbstractProcessApplication)rawObject;
                return abstractProcessApplication.getEnvironmentScripts();
            }
            return null;
        }
        catch (ProcessApplicationUnavailableException e) {
            throw new ProcessEngineException("Process Application is unavailable.", e);
        }
    }

    protected List<ExecutableScript> getEnvScripts(ExecutableScript script, ScriptEngine scriptEngine) {
        List<ExecutableScript> envScripts = this.getEnvScripts(script.getLanguage().toLowerCase());
        if (envScripts.isEmpty()) {
            envScripts = this.getEnvScripts(scriptEngine.getFactory().getLanguageName().toLowerCase());
        }
        return envScripts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ExecutableScript> getEnvScripts(String scriptLanguage) {
        Map<String, List<ExecutableScript>> environment = this.getEnv(scriptLanguage);
        List<ExecutableScript> envScripts = environment.get(scriptLanguage);
        if (envScripts == null) {
            ScriptingEnvironment scriptingEnvironment = this;
            synchronized (scriptingEnvironment) {
                envScripts = environment.get(scriptLanguage);
                if (envScripts == null) {
                    envScripts = this.initEnvForLanguage(scriptLanguage);
                    environment.put(scriptLanguage, envScripts);
                }
            }
        }
        return envScripts;
    }

    protected List<ExecutableScript> initEnvForLanguage(String language) {
        ArrayList<ExecutableScript> scripts = new ArrayList<ExecutableScript>();
        for (ScriptEnvResolver resolver : this.envResolvers) {
            String[] resolvedScripts = resolver.resolve(language);
            if (resolvedScripts == null) continue;
            for (String resolvedScript : resolvedScripts) {
                scripts.add(this.scriptFactory.createScriptFromSource(language, resolvedScript));
            }
        }
        return scripts;
    }
}

