/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.impl.ProcessEngineImpl;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.db.DbEntity;
import org.eximeebpms.bpm.engine.impl.el.ExpressionManager;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;
import org.eximeebpms.bpm.engine.runtime.ProcessElementInstance;

public final class StringUtil {
    public static int DB_MAX_STRING_LENGTH = 666;

    public static boolean isExpression(String text) {
        return (text = text.trim()).startsWith("${") || text.startsWith("#{");
    }

    public static boolean isCompositeExpression(String text, ExpressionManager expressionManager) {
        return !expressionManager.createExpression(text).isLiteralText();
    }

    public static String[] split(String text, String regex) {
        if (text == null) {
            return null;
        }
        if (regex == null) {
            return new String[]{text};
        }
        String[] result = text.split(regex);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    public static boolean hasAnySuffix(String text, String[] suffixes) {
        for (String suffix : suffixes) {
            if (!text.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static String fromBytes(byte[] bytes) {
        EnsureUtil.ensureActiveCommandContext("StringUtil.fromBytes");
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        return StringUtil.fromBytes(bytes, processEngineConfiguration.getProcessEngine());
    }

    public static String fromBytes(byte[] bytes, ProcessEngine processEngine) {
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        Charset charset = processEngineConfiguration.getDefaultCharset();
        return bytes != null ? new String(bytes, charset) : new String();
    }

    public static Reader readerFromBytes(byte[] bytes) {
        EnsureUtil.ensureActiveCommandContext("StringUtil.readerFromBytes");
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return new InputStreamReader((InputStream)inputStream, processEngineConfiguration.getDefaultCharset());
    }

    public static Writer writerForStream(OutputStream outStream) {
        EnsureUtil.ensureActiveCommandContext("StringUtil.readerFromBytes");
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        return new OutputStreamWriter(outStream, processEngineConfiguration.getDefaultCharset());
    }

    public static byte[] toByteArray(String string) {
        EnsureUtil.ensureActiveCommandContext("StringUtil.toByteArray");
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        return StringUtil.toByteArray(string, processEngineConfiguration.getProcessEngine());
    }

    public static byte[] toByteArray(String string, ProcessEngine processEngine) {
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        Charset charset = processEngineConfiguration.getDefaultCharset();
        return string.getBytes(charset);
    }

    public static String trimToMaximumLengthAllowed(String string) {
        if (string != null && string.length() > DB_MAX_STRING_LENGTH) {
            return string.substring(0, DB_MAX_STRING_LENGTH);
        }
        return string;
    }

    public static String joinDbEntityIds(Collection<? extends DbEntity> dbEntities) {
        return StringUtil.join(new StringIterator<DbEntity>(dbEntities.iterator()){

            @Override
            public String next() {
                return ((DbEntity)this.iterator.next()).getId();
            }
        });
    }

    public static String joinProcessElementInstanceIds(Collection<? extends ProcessElementInstance> processElementInstances) {
        Iterator<? extends ProcessElementInstance> iterator = processElementInstances.iterator();
        return StringUtil.join(new StringIterator<ProcessElementInstance>(iterator){

            @Override
            public String next() {
                return ((ProcessElementInstance)this.iterator.next()).getId();
            }
        });
    }

    public static boolean hasText(String string) {
        return string != null && !string.isEmpty();
    }

    public static String join(Iterator<String> iterator) {
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static abstract class StringIterator<T>
    implements Iterator<String> {
        protected Iterator<? extends T> iterator;

        public StringIterator(Iterator<? extends T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

