/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.util.io;

import java.io.InputStream;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;
import org.eximeebpms.bpm.engine.impl.util.ReflectUtil;
import org.eximeebpms.bpm.engine.impl.util.io.StreamSource;

public class ResourceStreamSource
implements StreamSource {
    String resource;
    ClassLoader classLoader;

    public ResourceStreamSource(String resource) {
        this.resource = resource;
    }

    public ResourceStreamSource(String resource, ClassLoader classLoader) {
        this.resource = resource;
        this.classLoader = classLoader;
    }

    @Override
    public InputStream getInputStream() {
        InputStream inputStream = null;
        if (this.classLoader == null) {
            inputStream = ReflectUtil.getResourceAsStream(this.resource);
        } else {
            this.classLoader.getResourceAsStream(this.resource);
        }
        EnsureUtil.ensureNotNull("resource '" + this.resource + "' doesn't exist", "inputStream", (Object)inputStream);
        return inputStream;
    }

    public String toString() {
        return "Resource[" + this.resource + "]";
    }
}

