/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.util.xml;

import java.util.ArrayDeque;
import java.util.Deque;
import org.eximeebpms.bpm.engine.impl.util.xml.Element;
import org.eximeebpms.bpm.engine.impl.util.xml.Parse;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ParseHandler
extends DefaultHandler {
    protected String defaultNamespace;
    protected Parse parse;
    protected Locator locator;
    protected Deque<Element> elementStack = new ArrayDeque<Element>();

    public ParseHandler(Parse parse) {
        this.parse = parse;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Element element = new Element(uri, localName, qName, attributes, this.locator);
        if (this.elementStack.isEmpty()) {
            this.parse.rootElement = element;
        } else {
            this.elementStack.peek().add(element);
        }
        this.elementStack.push(element);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.elementStack.peek().appendText(String.valueOf(ch, start, length));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.elementStack.pop();
    }

    @Override
    public void error(SAXParseException e) {
        this.parse.addError(e);
    }

    @Override
    public void fatalError(SAXParseException e) {
        this.parse.addError(e);
    }

    @Override
    public void warning(SAXParseException e) {
        this.parse.addWarning(e);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }
}

