/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.variable.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import org.eximeebpms.bpm.engine.impl.util.IoUtil;
import org.eximeebpms.bpm.engine.impl.util.ReflectUtil;
import org.eximeebpms.bpm.engine.impl.variable.serializer.AbstractObjectValueSerializer;
import org.eximeebpms.bpm.engine.variable.Variables;

public class JavaObjectSerializer
extends AbstractObjectValueSerializer {
    public static final String NAME = "serializable";

    public JavaObjectSerializer() {
        super(Variables.SerializationDataFormats.JAVA.getName());
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected boolean isSerializationTextBased() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object deserializeFromByteArray(byte[] bytes, String objectTypeName) throws Exception {
        Object object;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ClassloaderAwareObjectInputStream ois = null;
        try {
            ois = new ClassloaderAwareObjectInputStream(bais);
            object = ois.readObject();
        }
        catch (Throwable throwable) {
            IoUtil.closeSilently(ois);
            IoUtil.closeSilently(bais);
            throw throwable;
        }
        IoUtil.closeSilently(ois);
        IoUtil.closeSilently(bais);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] serializeToByteArray(Object deserializedObject) throws Exception {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream ois = null;
        try {
            ois = new ObjectOutputStream(baos);
            ois.writeObject(deserializedObject);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            IoUtil.closeSilently(ois);
            IoUtil.closeSilently(baos);
            throw throwable;
        }
        IoUtil.closeSilently(ois);
        IoUtil.closeSilently(baos);
        return byArray;
    }

    @Override
    protected String getTypeNameForDeserialized(Object deserializedObject) {
        return deserializedObject.getClass().getName();
    }

    @Override
    protected boolean canSerializeValue(Object value) {
        return value instanceof Serializable;
    }

    protected static class ClassloaderAwareObjectInputStream
    extends ObjectInputStream {
        public ClassloaderAwareObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return ReflectUtil.loadClass(desc.getName());
        }
    }
}

