/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.test;

import java.io.FileNotFoundException;
import java.util.Date;
import junit.framework.TestCase;
import org.eximeebpms.bpm.engine.AuthorizationService;
import org.eximeebpms.bpm.engine.CaseService;
import org.eximeebpms.bpm.engine.FilterService;
import org.eximeebpms.bpm.engine.FormService;
import org.eximeebpms.bpm.engine.HistoryService;
import org.eximeebpms.bpm.engine.IdentityService;
import org.eximeebpms.bpm.engine.ManagementService;
import org.eximeebpms.bpm.engine.ProcessEngine;
import org.eximeebpms.bpm.engine.ProcessEngineConfiguration;
import org.eximeebpms.bpm.engine.RepositoryService;
import org.eximeebpms.bpm.engine.RuntimeService;
import org.eximeebpms.bpm.engine.TaskService;
import org.eximeebpms.bpm.engine.impl.test.ProcessEngineAssert;
import org.eximeebpms.bpm.engine.impl.test.TestHelper;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;

public class ProcessEngineTestCase
extends TestCase {
    protected String configurationResource = "eximeebpms.cfg.xml";
    protected String configurationResourceCompat = "activiti.cfg.xml";
    protected String deploymentId = null;
    protected ProcessEngine processEngine;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    @Deprecated
    protected HistoryService historicDataService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected FormService formService;
    protected FilterService filterService;
    protected AuthorizationService authorizationService;
    protected CaseService caseService;
    protected boolean skipTest = false;

    public void assertProcessEnded(String processInstanceId) {
        ProcessEngineAssert.assertProcessEnded(this.processEngine, processInstanceId);
    }

    protected void setUp() throws Exception {
        boolean hasRequiredHistoryLevel;
        super.setUp();
        if (this.processEngine == null) {
            this.initializeProcessEngine();
            this.initializeServices();
        }
        boolean bl = this.skipTest = !(hasRequiredHistoryLevel = TestHelper.annotationRequiredHistoryLevelCheck(this.processEngine, ((Object)((Object)this)).getClass(), this.getName(), new Class[0]));
        if (!this.skipTest) {
            this.deploymentId = TestHelper.annotationDeploymentSetUp(this.processEngine, ((Object)((Object)this)).getClass(), this.getName(), new Class[0]);
        }
    }

    protected void runTest() throws Throwable {
        if (!this.skipTest) {
            super.runTest();
        }
    }

    protected void initializeProcessEngine() {
        try {
            this.processEngine = TestHelper.getProcessEngine(this.getConfigurationResource());
        }
        catch (RuntimeException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof FileNotFoundException) {
                this.processEngine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource(this.configurationResourceCompat).buildProcessEngine();
            }
            throw ex;
        }
    }

    protected void initializeServices() {
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.historicDataService = this.processEngine.getHistoryService();
        this.historyService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
        this.managementService = this.processEngine.getManagementService();
        this.formService = this.processEngine.getFormService();
        this.filterService = this.processEngine.getFilterService();
        this.authorizationService = this.processEngine.getAuthorizationService();
        this.caseService = this.processEngine.getCaseService();
    }

    protected void tearDown() throws Exception {
        TestHelper.annotationDeploymentTearDown(this.processEngine, this.deploymentId, ((Object)((Object)this)).getClass(), this.getName());
        ClockUtil.reset();
        super.tearDown();
    }

    public static void closeProcessEngines() {
        TestHelper.closeProcessEngines();
    }

    public void setCurrentTime(Date currentTime) {
        ClockUtil.setCurrentTime(currentTime);
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }
}

